package jp.sourceforge.shovel;

public enum MethodType {
    RELOAD      ("reload"),
    PAGE        ("page"),
    SORT_ORDER  ("sortOrder");
    
    String id_;
    
    MethodType(String id) {
        id_ = id;
    }
    public String getId() {
        return id_;
    }
    public static MethodType find(String id) {
        for(MethodType methodType : MethodType.values()) {
            if(methodType.getId().compareToIgnoreCase(id) == 0) {
                return methodType;
            }
        }
        return RELOAD;
    }
    public boolean isReload() {
        return this == RELOAD;
    }
    public boolean isPage() {
        return this == PAGE;
    }
    public boolean isSortOrder() {
        return this == SORT_ORDER;
    }
}
