package jp.sourceforge.shovel;

public enum ErrorPageType {
    ATOM            ("atom"),
    HTML            ("html"),
    IFRAME          ("iframe"),
    JSON            ("json"),
    RSS             ("rss"),
    XHR             ("xhr"),
    XML             ("xml"),
    MOBILE_PHONE    ("mobilePhone");
    
    String key_;
    
    ErrorPageType(String key) {
        key_ = key;
    }
    public String getKey() {
        return key_;
    }
    public static ErrorPageType find(String key) {
        for(ErrorPageType type :ErrorPageType.values()) {
            if(key.compareTo(type.getKey()) == 0) {
                return type;
            }
        }
        return null;
    }
    
    public boolean isAtom() {
        return this == ATOM;
    }
    public boolean isHtml() {
        return this == HTML;
    }
    public boolean isIframe() {
        return this == IFRAME;
    }
    public boolean isJson() {
        return this == JSON;
    }
    public boolean isRss() {
        return this == RSS;
    }
    public boolean isXhr() {
        return this == XHR;
    }
    public boolean isXml() {
        return this == XML;
    }
    public boolean isMobile() {
        return this == MOBILE_PHONE;
    }
}
