package jp.sourceforge.shovel;

public enum DeviceType {
    UNKNOWN     (0, "unknown"),
    JABBER      (1, "jabber"),
    GTALK       (2, "gtalk"),
    MSNP        (3, "msnp");
    
    int id_;
    String key_;
    
    DeviceType(int id, String key) {
        id_ = id;
        key_ = key;
    }
    public int getId() {
        return id_;
    }
    public String getKey() {
        return key_;
    }
    public static DeviceType find(String key) {
        if (key != null) {
            for (DeviceType type : DeviceType.values()) {
                if (key.compareTo(type.getKey()) == 0) {
                    return type;
                }
            }
        }
        return UNKNOWN;
    }
    public boolean isUnknown() {
        return this == UNKNOWN;
    }
    public boolean isJabber() {
        return this == JABBER;
    }
    public boolean isGTalk() {
        return this == GTALK;
    }
    public boolean isMsnp() {
        return this == MSNP;
    }
}
