<#import "/macro.ftl" as macro />
<#macro friend friendship>
  <#local common=JspTaglibs["/WEB-INF/tld/common.tld"] />
  <#local bean_el=JspTaglibs["http://struts.apache.org/tags-bean-el"] />
  <#if friends?has_content>
    <#local sender=friendship.passive />
  <#else>
    <#local sender=friendship.active />
  </#if>
{<#t />
  "id":${sender.userId},<#t />
  "name":"<@common.ncrEncode data=sender.displayName escape="json" />",<#t />
  "screen_name":"${sender.foreignKey?js_string}",<#t />
  "location":"<@common.ncrEncode data=sender.location />",<#t />
  "description":"<@common.ncrEncode data=sender.description />",<#t />
  "profile_image_url":"<@macro.userThumbnailUrl user=sender />",<#t />
  "protected":false,<#t />
  "followers_count":${sender.followers},<#t />
  <#assign status=statuses[sender.userId?string]?default("") />
  <#if status?has_content>
  "status":{<#t />
    "created_at":"<@common.dateFormat date=status.sentTime format="dateTime.compatible.twitter" timeZoneID="UTC" lang="en" />",<#t />
    "id":${status.statusId},<#t />
    "text":"<@common.ncrEncode data=status.body escape="json" />",<#t />
    "source":"<@macro.sourceWithLink source=status.source dedicatedClient=status.dedicatedClient escape="json" />",<#t />
    "truncated":false,<#t />
    <#if status.referenceId &gt; 0>
    "in_reply_to_status_id":${status.referenceId},<#t />
    "in_reply_to_user_id":${status.referenceSenderId},<#t />
    <#else>
    "in_reply_to_status_id":null,<#t />
    "in_reply_to_user_id":null,<#t />
    </#if>
    "favorited":<#t />
    <#if status.favorite?has_content>
      true<#t />
    <#else>
      false<#t />
    </#if>
  }<#t />
  <#else>
  "status":null<#t />
  </#if>
}<#t />
</#macro>
<#if friendship?has_content>
<@friend friendship=friendship />
<#elseif friendships?has_content>
{<#t />
  <#list friendships as friendship>
    <@friend friendship=friendship /><#t />
  </#list>
}<#t />
</#if>
