<#macro exportDirectMessage directMessage>
<#local common=JspTaglibs["/WEB-INF/tld/common.tld"] />
<#local bean_el=JspTaglibs["http://struts.apache.org/tags-bean-el"] />
<#import "/macro.ftl" as macro />
{<#t />
    "id":${directMessage.directMessageId},<#t />
    "text":"<@common.ncrEncode data=directMessage.text escape="json" />",<#t />
    "sender_id":${directMessage.senderId},<#t />
    "recipient_id":${directMessage.recipientId},<#t />
    "created_at":"<@common.dateFormat date=directMessage.sentTime format="dateTime.compatible.twitter" timeZoneID="UTC" lang="en" />",<#t />
<#assign sender=directMessage.sender?default("")/>
    "sender":<#t />
<#if sender?has_content>
      {<#t />
        "id":${sender.userId},<#t />
        "name":"<@common.ncrEncode data=sender.displayName escape="json" />",<#t />
        "screen_name":"${sender.foreignKey?js_string}",<#t />
        "location":"<@common.ncrEncode data=sender.location escape="json" />",<#t />
        "description":"<@common.ncrEncode data=sender.description escape="json" />",<#t />
        "profile_image_url":"<@macro.userThumbnailUrl user=sender />",<#t />
        "protected":false,<#t />
        "followers_count":${sender.followers}<#t />
      },<#t />
<#else>
      null,<#t />
</#if>
<#assign recipient=directMessage.recipient?default("")/>
    "recipient":<#t />
<#if recipient?has_content>
      {<#t />
        "id":${recipient.userId},<#t />
        "name":"<@common.ncrEncode data=recipient.displayName escape="json" />",<#t />
        "screen_name":"${recipient.foreignKey}",<#t />
        "location":"<@common.ncrEncode data=recipient.location escape="json" />",<#t />
        "description":"<@common.ncrEncode data=recipient.description escape="json" />",<#t />
        "profile_image_url":"<@macro.userThumbnailUrl user=recipient />",<#t />
        "protected":false,<#t />
        "followers_count":${recipient.followers}<#t />
      }<#t />
<#else>
    null<#t />
</#if>
}<#t />
</#macro>
<#if directMessages?has_content>
[<#t />
<#list directMessages as directMessage>
<@exportDirectMessage directMessage=directMessage /><#t />
<#if directMessage_has_next>,</#if><#t />
</#list>
]<#t />
<#elseif directMessage?has_content>
<@exportDirectMessage directMessage=directMessage />
</#if>
