package jp.sourceforge.shovel.servlet.freemarker;

import static org.seasar.framework.container.ContainerConstants.*;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import net.arnx.jsonic.JSON;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ResourceUtil;

import freemarker.ext.servlet.FreemarkerServlet;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

import jp.sourceforge.shovel.entity.TokenProcessorWrapper;

import static jp.sourceforge.shovel.ICommonConst.*;

public class FreemarkerServletWrapper extends FreemarkerServlet {
    static final long serialVersionUID = -1L;
    
    public void init() throws ServletException {
        super.init();
        Configuration config = getConfiguration();
        config.setTemplateLoader(new WebappTemplateLoaderExt(this.getServletContext(), getTemplatePath()));
    }
    
    protected boolean preTemplateProcess(HttpServletRequest request, HttpServletResponse response,
            Template template, TemplateModel data) throws ServletException, IOException {
        //出力文字コードの書き換え
        String encoding = (String)request.getAttribute(OUTPUT_ENCODING);
        if( encoding == null ) {
            //TODO デフォルトのエンコーディングはutf-8？
            encoding = "UTF-8";
        }
        response.setCharacterEncoding(encoding);
        //ContentTypeの書き換え
        String mimeType = (String)request.getAttribute(OUTPUT_MIMETYPE);
        if( mimeType != null ) {
            response.setContentType(mimeType + ";charset=" + encoding);
        }
        
        //定数の割り当て
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Properties props = (Properties)container.getComponent(COMMON_PROPERTIES);
        boolean debug = Boolean.parseBoolean(props.getProperty("debug", "false"));
        String webRoot = props.getProperty(KEY_WEBROOT, "");
        String appPath = request.getContextPath();
        StringBuffer url = request.getRequestURL();
        String baseUrl = "";
        try {
            URI uri = new URI(url.toString());
            uri = new URI(uri.getScheme(), null, uri.getHost(),
                    uri.getPort(), null, null, null);
            baseUrl = uri.toString();
        } catch (URISyntaxException e) {
            //TODO とりあえず握りつぶしとく
        }
        request.setAttribute("debug", debug);
        request.setAttribute(KEY_WEBROOT, webRoot);
        request.setAttribute("app_path", appPath);
        request.setAttribute("base_url", baseUrl);
        
        //リリース時はバージョン番号
        String version = (String)props.getProperty("version");
        if (debug || version == null) {
            long time = Calendar.getInstance().getTimeInMillis();
            version = String.valueOf(time);
        }
        request.setAttribute("version", version);
        
        //レスポンスバウンダリ
        String salt = String.valueOf(System.currentTimeMillis());
        String token = new TokenProcessorWrapper().generateToken(salt);
        String boundary = RESPONSE_BOUNDARY + token;
        request.setAttribute(BOUNDARY, boundary);
        response.setHeader(RESPONSE_BOUNDARY_HEADER, boundary);
        
        //JavaScriptで使うメッセージリソース
        props = ResourceUtil.getProperties("jp/sourceforge/shovel/js.properties");
        request.setAttribute("jsres", JSON.encode(props));
        
        return super.preTemplateProcess(request, response, template, data);
    }
    
    Configuration config_;
    
    protected Configuration createConfiguration() {
        config_ = super.createConfiguration();
        return config_;
    }
    
    ObjectWrapper wrapper_;
    
    protected ObjectWrapper createObjectWrapper() {
        wrapper_ = super.createObjectWrapper();
        
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Map applicationScope = (Map)container.getComponent(APPLICATION_SCOPE);
        //TODO 起動時にFreemarkerのサーブレットをアプリケーションスコープに積む反則技
        applicationScope.put("freemarkerServlet", this);
        
        return wrapper_;
    }

    public StringBuffer processNow(String path, HttpServletRequest request, HttpServletResponse response) {
        ServletContext servletContext = getServletContext();
        StringWriter writer = new StringWriter();
        
        try {
            Template template = config_.getTemplate(path);
            TemplateModel model = createModel(wrapper_, servletContext, request, response);
            
            // Give subclasses a chance to hook into preprocessing
            if (preTemplateProcess(request, response, template, model)) {
                try {
                    // Process the template
                    template.process(model, writer);
                } finally {
                    // Give subclasses a chance to hook into postprocessing
                    postTemplateProcess(request, response, template, model);
                }
            }
        } catch (IOException ex) {
        } catch (TemplateException ex) {
        } catch (ServletException ex) {
        }

        return writer.getBuffer();
    }
}
