package jp.sourceforge.shovel.service;

import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.entity.IConnectionWrapper;
import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IShovelService {
    IStatus getStatus(long statusId);
    IStatus getRecent(String foreignKey);
    IStatus getRecent(long userId);
    IStatus[] getRecents(long[] userIds);
    IStatus[] getStatuses(int page, int limit);
    IStatus[] getStatuses(long sinceId, int limit);
    IStatus[] getStatuses(SortType sortType, SortOrderType sortOrderType, int limit);
    //correct*はlimitの補正値
    IStatus[] getStatuses(String foreignKey, boolean withFriends, int page, int limit, int correctedOffset, int correctedLimit) throws ApplicationException;
    IStatus[] getStatuses(String foreignKey, boolean withFriends, String since, int limit) throws ApplicationException;
    IStatus[] getReplies(String foreignKey, int page, int limit) throws ApplicationException;
    IStatus[] getFavorites(String foreignKey, int page, int limit) throws ApplicationException;
    
    IStatus updateStatus(String status, String source) throws ApplicationException;
    
    int removeStatus(long statusId) throws ApplicationException;
    
    IStatus[] truncate(IStatus[] statuses, int limit);
    IStatus[] prepareForView(IStatus[] statuses, int limit, boolean truncate);
    
    void outputFeed(FormatType formatType, ViewType viewType, IUser user, IStatus[] statuses) throws ApplicationException;
    void outputFeed(FormatType formatType, ViewType viewType, IUser user, IDirectMessage[] directMessages) throws ApplicationException;
    
    /////
    
    IDirectMessage getDirectMessage(long directMessageId);
    IDirectMessage[] getDirectMessages(boolean sent, int page, int limit);
    IDirectMessage[] getDirectMessages(boolean sent, long sinceId, int limit);
    IDirectMessage[] getDirectMessages(boolean sent, String since, int limit) throws ApplicationException;
    
    IDirectMessage sendDirectMessage(String foreignKey, String text, String source) throws ApplicationException;
    IDirectMessage sendDirectMessage(long userId, String text, String source) throws ApplicationException;
    int removeDirectMessage(long directMessageId) throws ApplicationException;
    
    IDirectMessage[] prepareForView(IDirectMessage[] directMessages, boolean truncate);
    
    /////
    
    boolean isFriend(String forneignKey) throws ApplicationException;
    boolean isFriend(long userId) throws ApplicationException;
    
    IFriendship[] getFriends(String foreignKey, int offset, int limit) throws ApplicationException;
    IFriendship[] getFriends(String foreignKey, boolean withFollower, int page, int limit) throws ApplicationException;
    IFriendship[] getFollowers(String foreignKey, int offset, int limit) throws ApplicationException;
    IFriendship[] getFollowers(String foreignKey, boolean withFriend, int page, int limit) throws ApplicationException;
    
    IFriendship createFriendship(String foreignKey) throws ApplicationException;
    IFriendship createFriendship(long userId) throws ApplicationException;
    int updateFriendshipNotify(long userId, boolean notify) throws ApplicationException;
    int updateFriendshipNotify(String foreignKey, boolean notify) throws ApplicationException;
    int removeFriendship(String foreignKey) throws ApplicationException;
    int removeFriendship(long userId) throws ApplicationException;
    
    IFriendship[] prepareForView(IFriendship[] friendships, int limit, boolean truncate);
    
    /////
    
    IFavorite[] getFavorites(long[] statusIds);
    IFavorite createFavorite(long statusId);
    int removeFavorite(long statusId);
    
    /////
    
    IDevice createDevice(DeviceType deviceType, String address);
    int activateDevice();
    int updateDevice(AvailabilityType availabilityType);
    int resetDevice();
    
    /////
    
    IDedicatedClient createClient(String key, String url, String version);
    int updateClient(IDedicatedClient client);
    IDedicatedClient getClient(String key);
    int removeClient(String key);
    
    /////
    
    IConnectionWrapper getConnectionWrapper(DeviceType deviceType);
    IConnectionWrapper[] getConnectionWrappers();

    /////
    
    IUser[] prepareForView(IUser[] users, int limit);

    IDirectoryService getDirectoryService();
    IServerFileService getServerFileService();
}
