package jp.sourceforge.shovel.service;

import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IDirectoryService {
    IUser createUser(String displayName, String foreignKey, String password, String email, IServerFile serverFile,
            String location, String timeZoneId, String description, boolean cache) throws ApplicationException;
    IUser createTemporaryUser();
    IUser login(String foreignKey, String password, boolean administrator, boolean once);
    void logout();
    IUser getLoginUser();
    IUser getUser(long userId);
    IUser getUser(String foreignKey);
    IUser[] getUsers(boolean remove, SortType sortType, SortOrderType sortOrderType, int limit);
    IUser[] getUsers(long[] userIds);
    IUser[] getUsers(String[] foreignKeys);
    IUser[] getRandUsers();
    
    int removeUser(long userId) throws ApplicationException;
    int removeUsers(long[] userIds);
    int updateUser(IUser user) throws ApplicationException;
    int updateUserFromImportCsv(IUser user) throws ApplicationException;
    int updateUserFromSettings(IUser user) throws ApplicationException;
    int updateReplies(RepliesType repliesType);
    int updatePassword(String password);
    int updatePicture(long serverFileId);
    int incrementFavorites(String foreignKey);
    int incrementFollowers(String foreignKey);
    int incrementFriends(String foreignKey);
    int incrementGivenFavorites(long userId);
    int incrementStatuses(String foreignKey);
    int incrementDirectMessages(String foreignKey);
    int decrementFavorites(String foreignKey);
    int decrementFavoritesByStatus(long statusId);
    int decrementFollowers(String foreignKey);
    int decrementFriends(String foreignKey);
    int decrementGivenFavorites(long userId);
    int decrementStatuses(String foreignKey);
    int decrementDirectMessages(String foreignKey);
}
