package jp.sourceforge.shovel.logic.impl;

import java.util.Calendar;
import java.util.TimeZone;

import org.seasar.framework.container.S2Container;


import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.dao.IUserDao;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IDirectoryLogic;

public class DirectoryLogicImpl implements IDirectoryLogic {
    final String emailPattern_ = "^[^@]+@[^.]+\\..+";
    
    public IUser createUser(String displayName, String foreignKey, String password, String email,
            long serverFileId, String location, String timeZoneId, String description, long creatorId) throws ApplicationException {
        long createdTime = Calendar.getInstance().getTimeInMillis();
        if (timeZoneId == null) {
            timeZoneId = TimeZone.getDefault().getID();
        }
        
        validateUser(displayName, foreignKey, email);
        
        IUser user = (IUser)getContainer().getComponent(IUser.class);
        user.setCreatorId(creatorId);
        user.setCreatedTime(createdTime);
        user.setDescription(description);
        user.setDisplayName(displayName);
        user.setEmail(email);
        user.setForeignKey(foreignKey);
        user.setLocation(location);
        user.setModifierId(creatorId);
        user.setModifiedTime(createdTime);
        user.setPassword(password);
        user.setServerFileId(serverFileId);
        user.setTimeZoneId(timeZoneId);
        //TODO
        user.setViewLines(10);
        getUserDao().insert(user);
        
        return user;
    }
    public IUser createTemporaryUser() {
        return (IUser)getContainer().getComponent(IUser.class);
    }
    public IUser getUser(long userId) {
        return getUserDao().find(userId);
    }
    public IUser getUserByForeignKey(String foreignKey) {
        return getUserDao().findByForeignKey(foreignKey);
    }
    public IUser getUserByDevice(DeviceType deviceType, String address) {
        return getUserDao().findByDevice(deviceType, address);
    }
    public IUser[] getUsers(boolean remove, SortType sortType, SortOrderType sortOrderType, int offset, int limit) {
        return getUserDao().findAll(remove, sortType, sortOrderType, offset, limit);
    }
    public IUser[] getUsers(long[] userIds) {
        if (userIds == null || userIds.length <= 0) {
            return new IUser[0];
        }
        return getUserDao().findAllByUser(userIds, userIds.length);
    }
    public IUser[] getUsers(String[] foreignKeys) {
        if (foreignKeys == null || foreignKeys.length <= 0) {
            return new IUser[0];
        }
        return getUserDao().findAllByForeignKey(foreignKeys, foreignKeys.length);
    }
    public IUser[] getRandUsers(boolean remove, int offset, int limit) {
        return getUserDao().findAllByRand(remove, offset, limit);
    }
    //データを残すので廃止
    public int removeUser(long userId) {
        return getUserDao().delete(userId);
    }
    //データを残すので廃止
    public int removeUsers(long[] userIds) {
        return getUserDao().deleteAll(userIds);
    }
    void validateUser(String displayName, String foreignKey, String email) throws ApplicationException {
        if (displayName == null || displayName.length() <= 0) {
            throw new ApplicationException("");
        }
        if (foreignKey == null || foreignKey.length() <= 0) {
            throw new ApplicationException("");
        }
        if (foreignKey.matches("[^\\w^\\-]*")) {
            throw new ApplicationException("");
        }
        if (email.length() > 0 && !email.matches(emailPattern_)) {
            throw new ApplicationException("");
        }
    }
    public int updateUser(IUser user) throws ApplicationException {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        user.setModifiedTime(modifiedTime);
        
        String displayName = user.getDisplayName();
        String foreignKey = user.getForeignKey();
        String email = user.getEmail();
        validateUser(displayName, foreignKey, email);
        
        return getUserDao().update(user);
    }
    public int updateUserFromImportCsv(IUser user) throws ApplicationException {
        //TODO 後で定数に
        if (user.getUserId() == 1) {
            //Administratorをcsvから変更させない
            throw new ApplicationException("");
        }

        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        user.setModifiedTime(modifiedTime);
        
        String displayName = user.getDisplayName();
        String foreignKey = user.getForeignKey();
        String email = user.getEmail();
        validateUser(displayName, foreignKey, email);
        
        return getUserDao().updateFromImportCsv(user);
    }
    public int updateUserFromSettings(IUser user) throws ApplicationException {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        user.setModifiedTime(modifiedTime);
        
        String displayName = user.getDisplayName();
        String foreignKey = user.getForeignKey();
        //TODO 後で定数に
        if (user.getUserId() == 1) {
            foreignKey = "Administrator";
            user.setForeignKey(foreignKey);
        }
        String email = user.getEmail();
        validateUser(displayName, foreignKey, email);
        
        return getUserDao().update(user);
    }
    public int updatePicture(long userId, long serverFileId) {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        return getUserDao().updatePicture(userId, serverFileId, modifiedTime);
    }
    public int updatePassword(long userId, String password) {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        return getUserDao().updatePassword(userId, password, modifiedTime);
    }
    public int updateReplies(long userId, RepliesType repliesType) {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        return getUserDao().updateReplies(userId, repliesType, modifiedTime);
    }
    public int updateRemove(long[] userIds) {
        long modifiedTime = Calendar.getInstance().getTimeInMillis();
        return getUserDao().updateRemove(userIds, modifiedTime, true);
    }
    public int decrementAllFriends(long[] userIds) {
        return getUserDao().updateDecrementAllFriends(userIds);
    }
    public int decrementAllFollower(long[] userIds) {
        return getUserDao().updateDecrementAllFollowers(userIds);
    }
    public int incrementFavorites(String foreignKey) {
        return getUserDao().updateIncrementFavorites(foreignKey);
    }
    public int incrementFollower(String foreignKey) {
        return getUserDao().updateIncrementFollowers(foreignKey);
    }
    public int decrementFollower(String foreignKey) {
        return getUserDao().updateDecrementFollowers(foreignKey);
    }
    public int incrementFriends(String foreignKey) {
        return getUserDao().updateIncrementFriends(foreignKey);
    }
    public int decrementFavorites(String foreignKey) {
        return getUserDao().updateDecrementFavorites(foreignKey);
    }
    public int decrementFavoritesByStatus(long statusId) {
        return getUserDao().updateDecrementFavoritesByStatus(statusId);
    }
    public int decrementFriends(String foreignKey) {
        return getUserDao().updateDecrementFriends(foreignKey);
    }
    public int incrementGivenFavorites(long userId) {
        return getUserDao().updateIncrementGivenFavorites(userId);
    }
    public int decrementGivenFavorites(long userId) {
        return getUserDao().updateDecrementGivenFavorites(userId);
    }
    public int incrementDirectMessages(String foreignKey) {
        return getUserDao().updateIncrementDirectMessages(foreignKey);
    }
    public int decrementDirectMessages(String foreignKey) {
        return getUserDao().updateDecrementDirectMessages(foreignKey);
    }
    public int incrementStatus(String foreignKey) {
        return getUserDao().updateIncrementStatuses(foreignKey);
    }
    public int decrementStatus(String foreignKey) {
        return getUserDao().updateDecrementStatuses(foreignKey);
    }
    
    /////
    
    S2Container container_;
    
    public S2Container getContainer() {
        return container_;
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    IUserDao getUserDao() {
        return (IUserDao)getContainer().getComponent(IUserDao.class);
    }
}
