package jp.sourceforge.shovel.logic;

import java.util.Map;

import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IConnectionWrapper;
import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusToken;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IShovelLogic {
    //status
    IStatus getStatus(long statusId);
    IStatus getRecent(long userId);
    IStatus[] getFavorites(long userId, int offset, int limit);
    IStatus[] getStatuses(int offset, int limit);
    IStatus[] getStatuses(long sinceId, int limit);
    IStatus[] getStatuses(SortType sortType, SortOrderType sortOrderType, int limit);
    IStatus[] getStatuses(long userId, boolean withFriends, RepliesType repliesType, int offset, int limit);
    IStatus[] getStatuses(long userId, boolean withFriends, RepliesType repliesType, String since, int limit) throws ApplicationException;
    IStatus[] getRecents(long[] userIds);
    IStatus[] getReplies(long userId, int offset, int limit);
    IStatusToken[] parseStatus(String status);
    IStatus updateStatus(String status, String source, long referenceSenderId, boolean open, long senderId) throws ApplicationException;
    int incrementGivenFavorites(long statusId);
    int decrementGivenFavorites(long statusId);
    int clearStatusReference(long statusId);
    void recvStatus(String status, String source, long referenceSenderId, boolean open, long senderId) throws ApplicationException;
    int updateStatusRemove(long statusId);
    int removeStatus();
    
    //direct message
    IDirectMessage getDirectMessage(long directMessageId);
    IDirectMessage[] getDirectMessages(boolean sent, long userId, int offset, int limit);
    IDirectMessage[] getDirectMessages(boolean sent, long userId, long sinceId, int limit);
    IDirectMessage[] getDirectMessages(boolean sent, long userId, String sentTime, int limit) throws ApplicationException;
    
    IDirectMessage sendDirectMessage(long receiverId, long senderId,
            String text, String source) throws ApplicationException;
    int updateRemoveDirectMessage(long directMessageId, boolean inbox);
    
    //friendship
    IFriendship getFriendship(long activeId, long passiveId);
    IFriendship[] getFriends(long activeId, long[] passiveIds);
    IFriendship[] getFriends(long activeId, int offset, int limit);
    IFriendship[] getFollowers(long passiveId, int offset, int limit);
    IFriendship[] getFollowers(long passiveId, long[] activeIds);
    IFriendship[] getFollowers(long passiveId, DeviceType deviceType,
            long friendshipId, int limit);
    
    IFriendship createFriendship(long activeId, long passiveId);
    int updateFriendshipNotify(long activeId, long passiveId, boolean notify);
    int removeFriendship(long activeId, long passiveId);
    
    //favorite
    IFavorite getFavorite(long statusId, long userId);
    IFavorite[] getFavorites(long[] statusIds, long userId);
    IFavorite createFavorite(long statusId, long userId);
    int removeFavorite(long statusId, long userId);
    
    //device
    IDevice createDevice(IDevice device);
    int updateDevice(IDevice device);
    
    //client
    IDedicatedClient createClient(String key, String url, String version);
    int updateClient(IDedicatedClient client);
    IDedicatedClient getClient(String key);
    IDedicatedClient[] getClients(String[] keys);
    int removeClient(String key);
    
    void setConnectionWrapperMap(Map<String, IConnectionWrapper> connectors);
    IConnectionWrapper getConnectionWrapper(DeviceType deviceType);
    IConnectionWrapper[] getConnectionWrappers();
}
