package jp.sourceforge.shovel.logic;

import java.io.InputStream;

import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IServerFileLogic {
    IServerFile getServerFile(long serverFileId);
    IServerFile[] getServerFiles(long[] serverFileIds);
    IServerFile[] getServerFiles(int offset, int limit);
    void createServerFile(IServerFile serverFile, boolean detectEncoding) throws ApplicationException;
    IServerFile createServerFile(String name, String contentType, int size, String charset, InputStream inputStream, boolean detectEncoding) throws ApplicationException;
    int removeServerFile(long serverFileId) throws ApplicationException;
    int removeServerFiles(long[] serverFileIds) throws ApplicationException;
}
