package jp.sourceforge.shovel.logic;

import jp.sourceforge.shovel.entity.IMimeType;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IMimeTypeLogic {
    IMimeType getMimeType( String extension );
    IMimeType getMimeTypeByFileName( String fileName );
    IMimeType[] getMimeTypeList( long offset, long limit );

    void addMimeType(IMimeType mime) throws ApplicationException;
    void addMimeType(String extension, String mimeType) throws ApplicationException;
    void updateMimeType(IMimeType mime);
    void removeMimeType(long[] mimeTypeIds);
}
