package jp.sourceforge.shovel.logic;

import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IDirectoryLogic {
    IUser getUser(long userId);
    IUser getUserByForeignKey(String foreignKey);
    IUser getUserByDevice(DeviceType deviceType, String jabberId);
    IUser[] getUsers(boolean remove, SortType sortType, SortOrderType sortOrderType, int offset, int limit);
    IUser[] getUsers(long[] userIds);
    IUser[] getUsers(String[] foreignKeys);
    IUser[] getRandUsers(boolean remove, int offset, int limit);
    IUser createUser(String displayName, String foreignKey, String password, String email, long serverFileId,
            String location, String timeZoneId, String description, long creatorId) throws ApplicationException;
    IUser createTemporaryUser();
    int decrementFavorites(String foreignKey);
    int decrementFavoritesByStatus(long statusId);
    int decrementFollower(String foreignKey);
    int decrementFriends(String foreignKey);
    int decrementGivenFavorites(long userId);
    int decrementStatus(String foreignKey);
    int decrementDirectMessages(String foreignKey);
    int incrementFavorites(String foreignKey);
    int incrementFollower(String foreignKey);
    int incrementFriends(String foreignKey);
    int incrementGivenFavorites(long userId);
    int incrementStatus(String foreignKey);
    int incrementDirectMessages(String foreignKey);
    int decrementAllFollower(long[] userIds);
    int decrementAllFriends(long[] userIds);
    int removeUser(long userId);
    int removeUsers(long[] userIds);
    int updateUser(IUser user) throws ApplicationException;
    int updateUserFromImportCsv(IUser user) throws ApplicationException;
    int updateUserFromSettings(IUser user) throws ApplicationException;
    int updatePassword(long userId, String password);
    int updatePicture(long userId, long serverFileId);
    int updateReplies(long userId, RepliesType repliesType);
    int updateRemove(long[] userIds);
}
