package jp.sourceforge.shovel.interceptor;

import static jp.sourceforge.shovel.ErrorPageType.*;
import static jp.sourceforge.shovel.ICommonConst.*;
import static jp.sourceforge.shovel.ISessionConst.*;
import static org.seasar.framework.container.ContainerConstants.*;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.sourceforge.shovel.ErrorPageType;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IConnectionWrapper;
import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.codec.binary.Base64;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.S2Container;

public class AuthenticateInterceptor extends AbstractInterceptor {
    static final long serialVersionUID = 1L;
    S2Container container_;
    
    public void setContainer(S2Container container) {
        container_ = container;
    }
    S2Container getContainer() {
        return container_;
    }
    HttpServletRequest getRequest() {
        return (HttpServletRequest)getContainer().getComponent(REQUEST_NAME);
    }
    HttpServletResponse getResponse() {
        return (HttpServletResponse)getContainer().getComponent(RESPONSE_NAME);
    }
    HttpSession getSession() {
        return (HttpSession)getContainer().getComponent(SESSION_NAME);
    }
    ServletContext getApplication() {
        return (ServletContext)getContainer().getComponent(SERVLET_CONTEXT_NAME);
    }
    IShovelService getShovelService() {
        HttpServletRequest request = getRequest();
        //TODO
        IShovelService shovelService = (IShovelService)request.getAttribute("shovelService");
        if (shovelService == null) {
            shovelService = (IShovelService)getContainer().getComponent(IShovelService.class);
            //TODO
            request.setAttribute("shovelService", shovelService);
        }
        return shovelService;
    }
    IDirectoryService getDirectoryService() {
        return getShovelService().getDirectoryService();
    }
    
    public Object invoke(MethodInvocation invocation) throws Throwable {
        HttpServletRequest request = getRequest();
        HttpServletResponse response = getResponse();
        HttpSession session = getSession();
        ServletContext context = getApplication();
        
        Perform annotation = invocation.getMethod().getAnnotation(Perform.class);
        ErrorPageType errorPageType = HTML;
        boolean login = true;
        boolean administrator = false;
        if (annotation != null) {
            login = annotation.login();
            administrator = annotation.administrator();
        }
        
        //ログインの要、不要が同じコントローラの場合、UrlRewriteFilterで振り分け
        //アドホックだけどね。。
        login |= request.getAttribute("login") != null;
        request.removeAttribute("login");
        
        FormatType formatType = FormatType.find(request.getParameter("format"));
        if (!formatType.isHtml()) {
            errorPageType = ErrorPageType.find(formatType.getId());
            request.setAttribute(OUTPUT_MIMETYPE, formatType.getMimeType());
        }
        String header = request.getHeader("X-Requested-With");
        if (header != null && header.compareToIgnoreCase("XMLHttpRequest") == 0) {
            errorPageType = XHR;
        }
        String parameter = request.getParameter("iframe");
        if (parameter != null) {
            errorPageType = IFRAME;
        }
        
        if (context.getAttribute("imagemagick") == null) {
            Properties props = (Properties)getContainer().getComponent(COMMON_PROPERTIES);
            String bindir = props.getProperty("imagemagick.bin");
            boolean imagemagick = false;
            if (bindir != null) {
                File file = new File(bindir);
                imagemagick = file.exists();
            }
            context.setAttribute("imagemagick", imagemagick);
        }
        if (context.getAttribute("device") == null) {
            IConnectionWrapper[] connections = getShovelService().getConnectionWrappers();
            boolean device = false;
            for (IConnectionWrapper connection : connections) {
                device |= connection.isConnected();
            }
            context.setAttribute("connections", connections);
            context.setAttribute("device", device);
        }
        
        //ちと躊躇われる。。
        ErrorPageType forward = (ErrorPageType)request.getAttribute(ERROR_PAGE_TYPE);
        //フォワード前の画面に従う
        if (forward != null) {
            errorPageType = forward;
        }
        request.setAttribute(ERROR_PAGE_TYPE, errorPageType);
        
        //URLRewriteFilterでBasic認証の要、不要を振り分ける
        IUser user = null;
        user = getDirectoryService().getLoginUser();
        if (request.getAttribute("basicAuthentication") != null) {
            header = request.getHeader("Authorization");
            if (header != null && header.length() > 0) {
                //ログインを試みる
                int i = header.indexOf("Basic");
                String base64 = header.substring(i + 6);
                byte[] authInfo = Base64.decodeBase64(base64.getBytes("UTF-8"));
                String auth = new String(authInfo, "UTF-8");
                String[] tokens = auth.split(":");
                String foreignKey, password = null;
                switch (tokens.length) {
                case 2:
                    password = tokens[1];
                case 1:
                    foreignKey = tokens[0];
                    break;
                default:
                    //TODO
                    throw new ApplicationException("");
                }
                //基本、Basic認証はログイン情報をセッションに積まない
                user = getDirectoryService().login(foreignKey, password, false, true);
            }
            request.setAttribute(ERROR_PAGE_TYPE, XML);
            if (user == null) {
                //Authorization Required
                response.addHeader("WWW-Authenticate", "Basic realm=\"Shovel API\"");
                response.setStatus(401);
                session.removeAttribute(S_LOGIN_REDIRECT_URL);
                //TODO
                throw new ApplicationException("");
            }
        }
        
        //専用クライアント
        header = request.getHeader("X-Twitter-Client");
        if (header != null && header.length() > 0) {
            String key = header;
            String url = request.getHeader("X-Twitter-Client-URL");
            String version = request.getHeader("X-Twitter-Client-Version");
            
            IDedicatedClient client = getShovelService().getClient(key);
            if (client == null) {
                getShovelService().createClient(key, url, version);
            } else if (version != null && client.getVersion() != null) {
                try {
                    if (Float.parseFloat(version) > Float.parseFloat(client.getVersion())) {
                        client.setVersion(version);
                        client.setUrl(url);
                        getShovelService().updateClient(client);
                    }
                } catch (NumberFormatException e) {
                    //握り潰す
                }
            }
        }
        
        request.setAttribute("loginUser", user);
        if (request.getParameter("logout") != null && session.getAttribute(S_LOGOUT) == null) {
            session.setAttribute(S_LOGOUT, true);
            login = true;
            user = null;
        }
        
        //ログインしてない、あるいは管理者でないユーザがシステム管理にアクセスした
        if (administrator && (user == null || !user.isAdministrator())) {
            session.setAttribute(S_ADMINISTRATOR, true);
            login = true;
            user = null;
        }
        
        if (login) {
            if (user == null) {
                String path = request.getRequestURI();
                Map parameterMap = new HashMap();
                parameterMap.putAll(request.getParameterMap());
                parameterMap.remove("logout");
                path = jp.sourceforge.shovel.util.HttpUtil.toRequestFullPath(path, parameterMap);
                path = path.substring(request.getContextPath().length());
                RequestDispatcher rd = request.getRequestDispatcher("/root.do");
                response.setHeader(LOGIN_BEFORE_HEADER, "1");
                rd.forward(request, response);
                return null;
            }
        }
        return invocation.proceed();
    }
    
}
