package jp.sourceforge.shovel.form.impl;

import org.seasar.struts.annotation.tiger.StrutsActionForm;
import org.seasar.struts.validator.annotation.tiger.Args;
import org.seasar.struts.validator.annotation.tiger.Required;
import org.seasar.struts.validator.annotation.tiger.ValidateOrder;

import jp.sourceforge.shovel.form.ILoginForm;

@StrutsActionForm(name = "loginForm")
public class LoginFormImpl implements ILoginForm {
    String account_;
    boolean administrator_;
    String password_;
    boolean saveAccount_;
    boolean logout_;

    public String getAccount() {
        return account_;
    }
    public boolean isAdministrator() {
        return administrator_;
    }
    public String getPassword() {
        return password_;
    }
    public boolean isSaveAccount() {
        return saveAccount_;
    }
    public boolean isLogout() {
        return logout_;
    }

    @ValidateOrder(1)
    @Required
    @Args(keys = "loginName",bundle = "validation.common.login")
    public void setAccount(String account) {
        account_ = account;
    }
    public void setAdministrator(boolean administrator) {
        administrator_ = administrator;
    }
    public void setPassword(String password) {
        password_ = password;
    }
    public void setSaveAccount(boolean saveAccount) {
        saveAccount_ = saveAccount;
    }
    public void setLogout(boolean logout) {
        logout_ = logout;
    }
}
