package jp.sourceforge.shovel.entity.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import jp.sourceforge.shovel.entity.IClient;
import jp.sourceforge.shovel.exception.ApplicationException;

public abstract class AbstractClientImpl implements IClient {
    String os_;
    String version_;
    
    public String getOs() {
        return os_;
    }
    public void setOs(String os) {
        os_ = os;
    }
    public String getVersion() {
        return version_;
    }
    public void setVersion(String version) {
        version_ = version;
    }
    public String encodeText(String text) throws ApplicationException {
        try {
            return URLEncoder.encode(text, "UTF-8");
        } catch (UnsupportedEncodingException ex) {
            throw new ApplicationException("");
        }
    }
    static S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
}
