package jp.sourceforge.shovel.entity;

//import java.util.concurrent.BlockingQueue;

import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.RosterListener;

import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.exception.ApplicationException;

public interface IConnectionWrapper
    extends ChatManagerListener, MessageListener, RosterListener {
    
    String getDevice();
    void setDevice(String device);
    DeviceType getDeviceType();
    void setDeviceType(DeviceType deviceType);
    String getDisplayName();
    void setDisplayName(String displayName);
    String getHost();
    void setHost(String host);
    String getUserId();
    void setUserId(String userId);
    String getPassword();
    void setPassword(String password);
    int getPort();
    void setPort(int port);
    void setSasl(boolean sasl);
    boolean isSasl();
    String getServiceName();
    void setServiceName(String serviceName);
    void setSsl(boolean ssl);
    boolean isSsl();
    
//    void setQueue(BlockingQueue<Object> queue);
    
    void connect() throws ApplicationException;
    void disconnect();
    void pushMessage(IStatus status) throws ApplicationException;
    void pushContact(IUser user) throws ApplicationException;
    void dispatch() throws ApplicationException;
    boolean isConnected();
}
