package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.impl.FriendshipImpl;

@S2Dao(bean = FriendshipImpl.class)
public interface IFriendshipDao {
    int insert(IFriendship friendship);
    
    @Arguments({"activeId", "passiveId", "notify"})
    int updateNotify(long activeId, long passiveId, boolean notify);
    
    @Arguments("friendship")
    int delete(IFriendship friendship);
    
    @Arguments({"activeId", "passiveId"})
    IFriendship find(long activeId, long passiveId);
    @Arguments({"activeId", "offset", "limit"})
    IFriendship[] findAllFriends(long activeId, int offset, int limit);
    @Arguments({"activeId", "passiveIds", "offset", "limit"})
    IFriendship[] findAllFriendsBy(long activeId, long[] passiveIds, int offset, int limit);
    @Arguments({"passiveId", "offset", "limit"})
    IFriendship[] findAllFollower(long passiveId, int offset, int limit);
    @Arguments({"passiveId", "deviceType", "friendshipId", "limit"})
    IFriendship[] findAllFollowerByDevice(long passiveId, DeviceType deviceType, long friendshipId, int limit);
    @Arguments({"passiveId", "activeIds", "offset", "limit"})
    IFriendship[] findAllFollowerBy(long passiveId, long[] activeIds, int offset, int limit);
}
