package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ISessionConst.*;
import static jp.sourceforge.shovel.ViewType.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.ArrayUtils;
import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IUserTimelineAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class UserTimelineActionImpl implements IUserTimelineAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    HttpSession session_;
    
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();

        String foreignKey = actionForm_.getForeignKey();
        long userId = actionForm_.getUserId();
        IUser user = null;
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
        } else if (foreignKey.matches("^[0-9]+$")) {
            user = directoryService.getUser(userId);
        } else {
            user = directoryService.getUser(foreignKey);
        }
        
        int page = actionForm_.getPage();
        String since = actionForm_.getSince();
        int limit = actionForm_.getCount();
        int correctedOffset = 0;
        int correctedLimit = 0;
        IStatus[] statuses = null;
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)session_.getAttribute(S_LIST_REFINE);
            if (listRefine == null || !listRefine.getViewType().isUserTimeline()) {
                listRefine = (IListRefine)container_.getComponent(IListRefine.class);
                session_.setAttribute(S_LIST_REFINE, listRefine);
            } else if (actionForm_.getMethodType().isPage()) {
                listRefine.setPage(actionForm_.getPage());
            }
            listRefine.setViewType(USER_TIMELINE);
            
            page = listRefine.getPage();
            limit = 0;
            if (page > 0) {
                correctedOffset = 1;
            }
            correctedLimit = 2;
            
            statuses = shovelService.getStatuses(user.getForeignKey(), false, page, limit, correctedOffset, correctedLimit);
        } else {
            if (since == null) {
                since = request_.getHeader("If-Modified-Since");
            }
            if (since == null) {
                statuses = shovelService.getStatuses(user.getForeignKey(), false, page, limit, 0, 0);
            } else {
                statuses = shovelService.getStatuses(user.getForeignKey(), false, since, limit);
            }
        }
        shovelService.prepareForView(statuses, limit, false);
        
        String forward = null;
        switch (formatType) {
        case HTML:
            shovelService.prepareForView(new IUser[] {user}, 1);
            request_.setAttribute("user", user);
            
            IStatus[] temp = statuses;
            IStatus status = null;
            if (page > 0) {
                status = shovelService.getRecent(user.getForeignKey());
                temp = (IStatus[])ArrayUtils.add(statuses, status);
            } else if (statuses.length > 0) {
                status = statuses[0];
                statuses = (IStatus[])ArrayUtils.subarray(statuses, 1, statuses.length);
            }
            request_.setAttribute("status", status);
            
            shovelService.prepareForView(new IUser[] {user}, 1);
            request_.setAttribute("user", user);
            IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
            request_.setAttribute("viewAllFriends", friendships.length > 100);
            friendships = shovelService.prepareForView(friendships, 100, true);
            request_.setAttribute("friendships", friendships);
            
            boolean friend = shovelService.isFriend(user.getForeignKey());
            request_.setAttribute("friend", friend);

            temp = statuses;
            statuses = shovelService.truncate(temp, limit);
            request_.setAttribute("nextPage", temp.length > statuses.length);
            
            forward = actionForm_.isPartial() ? PARTIAL : FULL;
            break;
        case XML:
        case JSON:
            forward = formatType.getId();
            break;
        case ATOM:
        case RSS:
            shovelService.outputFeed(formatType, USER_TIMELINE, user, statuses);
            break;
        default:
            throw new ApplicationException("");
        }
        request_.setAttribute("statuses", statuses);
        
        return forward;
    }
    
    public void setStatusesForm(IStatusesForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
     }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
}
