package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ICommonConst.*;
import static jp.sourceforge.shovel.ISessionConst.*;
import static jp.sourceforge.shovel.SortType.*;

import java.util.Properties;
import java.util.TimeZone;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SystemConfigType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.ISystemAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.ISystemForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class SystemActionImpl implements ISystemAction {
    ISystemForm actionForm_;
    S2Container container_;
    HttpServletRequest request_;
    HttpSession session_;
    
    @Perform(CSRF=false, administrator=true)
    public String perform() throws Exception {
        IListRefine listRefine = (IListRefine)session_.getAttribute(S_LIST_REFINE);
        if (listRefine == null || !listRefine.getViewType().isAccounts()) {
            listRefine = (IListRefine)container_.getComponent(IListRefine.class);
            session_.setAttribute(S_LIST_REFINE, listRefine);
        } else if (actionForm_.getMethodType().isPage()) {
            listRefine.setPage(actionForm_.getPage());
        } else if (actionForm_.getMethodType().isSortOrder()) {
            listRefine.setSortOrder(actionForm_.getSortOrder());
            listRefine.setPage(0);
        }
        listRefine.setViewType(ViewType.ACCOUNTS);
        
        SystemConfigType configType = actionForm_.getConfigType();
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = null;
        switch (configType) {
        case ACCOUNTS:
            SortOrderType sortOrderType = listRefine.getSortOrderType();
            int page = listRefine.getPage();
            
            IUser[] users = directoryService.getUsers(false, USER_ID, sortOrderType, page);
            if (users != null && users.length > 0) {
                IUser[] tmp = shovelService.prepareForView(users, 0);
                request_.setAttribute("nextPage", users.length > tmp.length);
                users = tmp;
            }
            request_.setAttribute("users", users);
            break;
        case IMPORT_ACCOUNTS:
            break;
        case UPDATE_ACCOUNT:
            user = directoryService.getUser(actionForm_.getUserId());
        case CREATE_ACCOUNT:
            if (user == null) {
                user = directoryService.createTemporaryUser();
            }
            shovelService.prepareForView(new IUser[] {user}, 1);
            String[] timeZoneIDs = TimeZone.getAvailableIDs();
            TimeZone[] timeZones = new TimeZone[timeZoneIDs.length];
            int i = 0;
            for (String timeZoneID : timeZoneIDs) {
                timeZones[i++] = TimeZone.getTimeZone(timeZoneID);
            }
            
            Properties props = (Properties)container_.getComponent(COMMON_PROPERTIES);
            String maxSize = props.getProperty("upload.maxSize");
            request_.setAttribute("maxSize", Integer.parseInt(maxSize));
            
            request_.setAttribute("user", user);
            request_.setAttribute("defaultTimeZone", TimeZone.getDefault());
            request_.setAttribute("timeZones", timeZones);
            request_.setAttribute("domain", request_.getServerName());
            request_.setAttribute("port", request_.getServerPort());
            break;
        default:
            throw new ApplicationException("");
        }
        request_.setAttribute("config", configType);
        
        return actionForm_.isPartial() ? configType.getForward() : SYSTEM;
    }
    public void setSystemForm(ISystemForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
