package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.SortOrderType.*;
import static jp.sourceforge.shovel.SortType.*;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.action.IStatisticsAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatisticsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class StatisticsActionImpl implements IStatisticsAction {
    IStatisticsForm actionForm_;
    HttpServletRequest request_;
    
    String compileUserStatistics(FormatType formatType, SortType sortType, int limit) throws ApplicationException {
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser[] users = directoryService.getUsers(false, sortType, DESC, limit);
        shovelService.prepareForView(users, users.length);
        request_.setAttribute("users", users);
        long[] userIds = new long[users.length];
        int i = 0;
        for (IUser user : users) {
            userIds[i++] = user.getUserId();
        }
        IStatus[] statuses = shovelService.getRecents(userIds);
        Map<String, IStatus> statusMap = new HashMap<String, IStatus>();
        for (IStatus status : statuses) {
            long statusId = status.getSenderId();
            statusMap.put(String.valueOf(statusId), status);
        }
        request_.setAttribute("statuses", statusMap);
        String forward;
        switch (formatType) {
        case XML:
            forward = USER_XML;
            break;
        case JSON:
            forward = USER_JSON;
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    String compileStatusStatistics(FormatType formatType, SortType sortType, int limit) throws ApplicationException {
        IShovelService shovelService = getShovelService();
        IStatus[] statuses = shovelService.getStatuses(sortType, DESC, limit);
        shovelService.prepareForView(statuses, limit, false);
        request_.setAttribute("statuses", statuses);
        String forward;
        switch (formatType) {
        case XML:
            forward = STATUS_XML;
            break;
        case JSON:
            forward = STATUS_JSON;
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    @Perform(CSRF=false)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        String forward;
        int limit = actionForm_.getCount();
        switch (actionForm_.getStatisticsType()) {
        case USER_STATUSES:
            forward = compileUserStatistics(formatType, STATUSES, limit);
            break;
        case USER_GIVEN_FAVORITES:
            forward = compileUserStatistics(formatType, GIVEN_FAVORITES, limit);
            break;
        case STATUS_GIVEN_FAVORITES:
            forward = compileStatusStatistics(formatType, GIVEN_FAVORITES, limit);
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    public void setStatisticsForm(IStatisticsForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
