package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.action.IPasswordAction;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IPasswordForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class PasswordActionImpl implements IPasswordAction {
    IPasswordForm actionForm_;
    HttpServletRequest request_;
    
    public String perform() throws Exception {
        IDirectoryService directoryService = getShovelService().getDirectoryService();
        IUser user = directoryService.getLoginUser();
        String password = actionForm_.getPassword();
        if (password == null || password.length() <= 0) {
            throw new ApplicationException("");
        }
        String confirmation = actionForm_.getConfirmation();
        if (password.compareTo(confirmation) != 0) {
            throw new ApplicationException("");
        }
        user.setPassword(password);
        directoryService.updateUser(user);
        return null;
    }
    public void setPasswordForm(IPasswordForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
