package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ISessionConst.*;
import static jp.sourceforge.shovel.ViewType.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IDirectMessagesAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IDirectMessagesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

//TODO 削除されたユーザーを友だちから削除
public class DirectMessagesActionImpl implements IDirectMessagesAction {
    IDirectMessagesForm actionForm_;
    HttpServletRequest request_;
    HttpSession session_;
    S2Container container_;
    
    @Perform(CSRF=false)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        
        int page = actionForm_.getPage();
        int limit = actionForm_.getCount();
        boolean sent = false;
        if (actionForm_.getSent() != null) {
            sent = actionForm_.getSent().compareTo("sent") == 0;
        }
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)session_.getAttribute(S_LIST_REFINE);
            if (listRefine == null || listRefine.getViewType().isInbox()) {
                listRefine = (IListRefine)container_.getComponent(IListRefine.class);
                session_.setAttribute(S_LIST_REFINE, listRefine);
            } else if (actionForm_.getMethodType().isPage()) {
                listRefine.setPage(actionForm_.getPage());
            }
            listRefine.setViewType(sent ? SENT: INBOX);
            
            page = listRefine.getPage();
            limit = 0;
        }
        
        IDirectMessage[] temp = shovelService.getDirectMessages(sent, page, limit);
        IDirectMessage[] directMessages = shovelService.prepareForView(temp, true);
        request_.setAttribute("directMessages", directMessages);
        
        String forward = null;
        switch (formatType) {
        case HTML:
            shovelService.prepareForView(new IUser[] {user}, 1);
            request_.setAttribute("user", user);
            
            String foreignKey = user.getForeignKey();
            IFriendship[] friendships = shovelService.getFriends(foreignKey, 0, 100);
            request_.setAttribute("viewAllFriends", friendships.length > 100);
            friendships = shovelService.prepareForView(friendships, 100, true);
            request_.setAttribute("friendships", friendships);
            
            boolean nextPage = false;
            if (directMessages != null && directMessages.length > 0) {
                nextPage = temp.length > directMessages.length;
            }
            request_.setAttribute("nextPage", nextPage);
            
            forward = actionForm_.isPartial() ? PARTIAL : FULL;
            break;
        case JSON:
        case XML:
            forward = formatType.getId();
            break;
        case ATOM:
        case RSS:
            shovelService.outputFeed(formatType, INBOX, user, directMessages);
            break;
        default:
            throw new ApplicationException("");
        }
        
        return forward;
    }
    
    public void setDirectMessagesForm(IDirectMessagesForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
}
