package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.action.IDestroyStatusAction;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusForm;
import jp.sourceforge.shovel.service.IShovelService;

public class DestroyStatusActionImpl implements IDestroyStatusAction {
    IStatusForm actionForm_;
    S2Container container_;
    HttpServletRequest request_;
    HttpSession session_;
    
    public String perform() throws Exception {
        IShovelService shovelService = getShovelService();
        shovelService.removeStatus(actionForm_.getStatusId());
        
        IStatus status = shovelService.getStatus(actionForm_.getStatusId());
        shovelService.prepareForView(new IStatus[] {status}, 1, false);
        request_.setAttribute("status", status);
        
        String forward = null;
        switch (actionForm_.getFormatType()) {
        case HTML:
            break;
        case JSON:
            forward = JSON;
            break;
        case XML:
            forward = XML;
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    public void setStatusForm(IStatusForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
}
