package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IDestroyFriendshipAction;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IFriendshipForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class DestroyFriendshipActionImpl implements IDestroyFriendshipAction {
    IFriendshipForm actionForm_;
    HttpServletRequest request_;
    
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        long userId = actionForm_.getUserId();
        String foreignKey = actionForm_.getForeignKey();
        if (foreignKey == null || foreignKey.length() <= 0) {
            IUser user = directoryService.getLoginUser();
            userId = user.getUserId();
            shovelService.removeFriendship(userId);
        } else if (foreignKey.matches("^[0-9]+$")) {
            foreignKey = null;
            shovelService.removeFriendship(userId);
        } else {
            userId = 0;
            shovelService.removeFriendship(foreignKey);
        }
        
        String forward = null;
        switch (formatType) {
        case XML:
        case JSON:
            IStatus status = null;
            if (userId > 0) {
                status = shovelService.getRecent(userId);
            } else {
                status = shovelService.getRecent(foreignKey);
            }
            
            if (status == null) {
                shovelService.prepareForView(new IStatus[] {status}, 1, false);
                request_.setAttribute("status", status);
            } else {
                IUser user;
                if (userId > 0) {
                    user = directoryService.getUser(userId);
                } else {
                    user = directoryService.getUser(foreignKey);
                }
                shovelService.prepareForView(new IUser[] {user}, 1);
                request_.setAttribute("user", user);
            }
            
            forward = formatType.getId();
            break;
        case HTML:
            break;
        default:
            throw new ApplicationException("");
        }
        
        return forward;
    }
    
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setFriendshipForm(IFriendshipForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
