package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ICommonConst.*;

import java.util.Properties;
import java.util.TimeZone;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.seasar.framework.container.S2Container;


import jp.sourceforge.shovel.AccountConfigType;
import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.action.IAccountAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IConnectionWrapper;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IAccountForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.HttpUtil;

public class AccountActionImpl implements IAccountAction {
    IAccountForm actionForm_;
    javax.servlet.ServletContext context_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    S2Container container_;
    
    @Perform(CSRF=false)
    public String perform() throws Exception {
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        AccountConfigType configType = actionForm_.getConfigType();
        
        if (!(Boolean)context_.getAttribute("device") && configType.equals(AccountConfigType.DEVICE)) {
            //基本情報にリダイレクト
            HttpUtil.sendRedirect(response_, "/account/settings");
            return null;
        }
        
        switch (configType) {
        case SETTINGS:
            String[] tzIDs = TimeZone.getAvailableIDs();
            TimeZone[] tzs = new TimeZone[tzIDs.length];
            int i = 0;
            for (String tzID : tzIDs) {
                tzs[i++] = TimeZone.getTimeZone(tzID);
            }
            request_.setAttribute("tzs", tzs);
            break;
        case DEVICE:
            IDevice device = user.getDevice();
            if (!device.getDeviceType().isUnknown()) {
                DeviceType deviceType = device.getDeviceType();
                IConnectionWrapper connectionWrapper = shovelService.getConnectionWrapper(deviceType);
                if (connectionWrapper == null) {
                    //設定が消えた？おかしいみたいだからやり直してもらう
                    getShovelService().resetDevice();
                } else {
                    StringBuilder address = new StringBuilder(connectionWrapper.getUserId());
                    address.append("@");
                    address.append(connectionWrapper.getServiceName());
                    request_.setAttribute("address", address.toString());
                    request_.setAttribute("releaseKey", user.getReleaseKey());
                }
            }
            break;
        case PICTURE:
            Properties props = (Properties)container_.getComponent(COMMON_PROPERTIES);
            String maxSize = props.getProperty("upload.maxSize");
            request_.setAttribute("maxSize", Integer.parseInt(maxSize));
            break;
        default:
            break;
        }
        shovelService.prepareForView(new IUser[] {user}, 1);
        
        request_.setAttribute("domain", request_.getServerName());
        request_.setAttribute("port", request_.getServerPort());
        request_.setAttribute("config", configType);
        request_.setAttribute("user", user);
        
        return actionForm_.isPartial() ? configType.getForward() : ACCOUNT;
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setContext(ServletContext context) {
        context_ = context;
    }
    public void setAccountForm(IAccountForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setResponse(HttpServletResponse response) {
        response_ = response;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
