package jp.sourceforge.shovel;

public enum StatisticsType {
    USER_STATUSES           ("user_statuses"),
    USER_GIVEN_FAVORITES    ("user_given_favorites"),
    STATUS_GIVEN_FAVORITES  ("status_given_favorites");
    
    String key_;
    
    StatisticsType(String key) {
        key_ = key;
    }
    public String getKey() {
        return key_;
    }
    public static StatisticsType find(String key) {
        for(StatisticsType type : values()) {
            if (key.compareToIgnoreCase(type.getKey()) == 0) {
                return type;
            }
        }
        return null;
    }
    public boolean isUserStatuses() {
        return this == USER_STATUSES;
    }
    public boolean isUserGivenFavorites() {
        return this == USER_GIVEN_FAVORITES;
    }
    public boolean isStatusGivenFavorites() {
        return this == STATUS_GIVEN_FAVORITES;
    }
}
