package jp.sourceforge.shovel;

public enum AvailabilityType {
    INACTIVATION    (0, "inactivation"),
    ON              (1, "everything"),
    OFF             (2, "nothing"),
    DIRECT_MESSAGE  (3, "direct_message");
    
    int id_;
    String key_;
    
    AvailabilityType(int id, String key) {
        id_ = id;
        key_ = key;
    }
    public int getId() {
        return id_;
    }
    public String getKey() {
        return key_;
    }
    public static AvailabilityType find(int id) {
        for (AvailabilityType type :AvailabilityType.values()) {
            if(id == type.getId()) {
                return type;
            }
        }
        return INACTIVATION;
    }
    public static AvailabilityType find(String key) {
        for (AvailabilityType type : AvailabilityType.values()) {
            if (key.compareTo(type.getKey()) == 0) {
                return type;
            }
        }
        return INACTIVATION;
    }
    public boolean isInactivation() {
        return this == INACTIVATION;
    }
    public boolean isOn() {
        return this == ON;
    }
    public boolean isOff() {
        return this == OFF;
    }
    public boolean isDirectMessage() {
        return this == DIRECT_MESSAGE;
    }
}
