package jp.sourceforge.shovel;

public enum AccountConfigType {
    SETTINGS        ("settings", "settings.ftl"),
    PASSWORD        ("password", "password.ftl"),
    DEVICE          ("device", "device.ftl"),
    NOTICES         ("notices", "notices.ftl"),
    PICTURE         ("picture", "picture.ftl"),
    DESIGN          ("design", "design.ftl");
    
    String forward_;
    String template_;
    
    AccountConfigType(String forward, String template) {
        forward_ = forward;
        template_ = template;
    }
    public String getForward() {
        return forward_;
    }
    public String getTemplate() {
        return template_;
    }
    public static AccountConfigType find(String forward) {
        forward = forward.toLowerCase();
        for(AccountConfigType type :AccountConfigType.values()) {
            if(type.getForward().equals(forward)) {
                return type;
            }
        }
        return null;
    }
}
