/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.io.File;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnFileTransferState;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnSwitchboard;

public abstract class AbstractFileTransfer
implements MsnFileTransfer {
    private final MsnSwitchboard switchboard;
    private final MsnContact contact;
    private MsnFileTransferState state = MsnFileTransferState.INIT;
    private File file;
    private long fileTotalSize = -1L;
    private long transferredSize = 0L;

    public AbstractFileTransfer(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
        this.switchboard = msnSwitchboard;
        this.contact = msnContact;
    }

    public MsnSwitchboard getSwitchboard() {
        return this.switchboard;
    }

    public MsnMessenger getMessenger() {
        return this.switchboard.getMessenger();
    }

    public MsnContact getContact() {
        return this.contact;
    }

    public MsnFileTransferState getState() {
        return this.state;
    }

    public boolean isReceiver() {
        return !this.isSender();
    }

    public long getFileTotalSize() {
        return this.fileTotalSize;
    }

    public long getTransferredSize() {
        return this.transferredSize;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IllegalStateException {
        if (file != null) {
            if (this.isStarted()) {
                throw new IllegalStateException("can't set file after transfer started");
            }
            this.file = file;
        }
    }

    public void setFileTotalSize(long l) {
        this.fileTotalSize = l;
    }

    protected void setTransferredSize(long l) {
        this.transferredSize = l;
    }

    protected void setState(MsnFileTransferState msnFileTransferState) {
        this.state = msnFileTransferState;
    }
}

