<?php
/*
 * framework-spider: アプリケーション固有のグローバル変数の定義用ファイル
 * @version 1.1.04
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.09.07
 * 
 */
/** 管理パネルフォルダ名 */
define('SYSTEM_DIR_NAME_ADMIN_PANEL', 'panel');

/**
 * リバースプロキシ設定
 * 	要素 : ホスト名 => array('protocol'=>'プロトコル', 'uri'=>'割り当てURI')
 */
$GLOBALS['REV_PROXY_HASH'] = array();

/** プログラム生成ファイルパーミッション: 公開フォルダ以下のphpファイル	*/
define('SPIDER_PERMITTION_PUBLIC_FILE',0666);
/** プログラム生成ファイルパーミッション: 公開フォルダ以下のフォルダ	*/
define('SPIDER_PERMITTION_PUBLIC_FOLDER',0777);

/** プログラム生成ファイルパーミッション: spiderフォルダ以下のファイル及びphp以外のファイル	*/
define('SPIDER_PERMITTION_DATA_FILE',0666);
/** プログラム生成ファイルパーミッション: spiderフォルダ以下のフォルダ	*/
define('SPIDER_PERMITTION_DATA_FOLDER',0777);

/** HTTPアクセス用の設置URL	*/
define('SPIDER_ACCESS_URL_HTTP','');
/** HTTPSアクセス用の設置URL	*/
define('SPIDER_ACCESS_URL_SSL',	'');
/** HTTPSアクセスを強制するフォルダURL配列: 設置フォルダを起点として絶対URIで記述	*/
$GLOBALS['SPIDER_ACCESS_SSL_URI_ARRAY']	= array('/member/','/shopping/order/','/'.SYSTEM_DIR_NAME_ADMIN_PANEL.'/');

/**
 * spiderデバッグ用コマンドを許可するIPアドレス
 * spiderdebugcmd= viewmoduletime/ 他検討
 */
$GLOBALS['SPIDER_DEBUG_COMMAND_PERMIT_ADDRESSES']	= array(
	'127.0.0.1',
);

/** 地域ハッシュ	*/
$GLOBALS['AREA_HASH']			= array(
	1	=> '北海道・東北',
	2	=> '関東',
	3	=> '甲信越・北陸',
	4	=> '東海',
	5	=> '関西',
	6	=> '中国',
	7	=> '四国',
	8	=> '九州',
);
/** 都道府県ハッシュ	*/
$GLOBALS['PREFECTURE_HASH']	= array(
	1=>'北海道',
	2=>'青森県',
	3=>'岩手県',
	4=>'宮城県',
	5=>'秋田県',
	6=>'山形県',
	7=>'福島県',
	8=>'東京都',
	9=>'神奈川県',
	10=>'埼玉県',
	11=>'千葉県',
	12=>'茨城県',
	13=>'栃木県',
	14=>'群馬県',
	15=>'山梨県',
	16=>'富山県',
	17=>'石川県',
	18=>'福井県',
	19=>'新潟県',
	20=>'長野県',
	21=>'愛知県',
	22=>'岐阜県',
	23=>'静岡県',
	24=>'三重県',
	25=>'大阪府',
	26=>'兵庫県',
	27=>'京都府',
	28=>'滋賀県',
	29=>'奈良県',
	30=>'和歌山県',
	31=>'鳥取県',
	32=>'島根県',
	33=>'岡山県',
	34=>'広島県',
	35=>'山口県',
	36=>'徳島県',
	37=>'香川県',
	38=>'愛媛県',
	39=>'高知県',
	40=>'福岡県',
	41=>'佐賀県',
	42=>'長崎県',
	43=>'熊本県',
	44=>'大分県',
	45=>'宮崎県',
	46=>'鹿児島県',
	47=>'沖縄県',
);
/** 都道府県エリアハッシュ	*/
$GLOBALS['PREFECTURE_AREA_HASH']	= array(
	1=>1,
	2=>1,
	3=>1,
	4=>1,
	5=>1,
	6=>1,
	7=>1,
	8=>2,
	9=>2,
	10=>2,
	11=>2,
	12=>2,
	13=>2,
	14=>2,
	15=>3,
	16=>3,
	17=>3,
	18=>3,
	19=>3,
	20=>3,
	21=>4,
	22=>4,
	23=>4,
	24=>4,
	25=>5,
	26=>5,
	27=>5,
	28=>5,
	29=>5,
	30=>5,
	31=>6,
	32=>6,
	33=>6,
	34=>6,
	35=>6,
	36=>7,
	37=>7,
	38=>7,
	39=>7,
	40=>8,
	41=>8,
	42=>8,
	43=>8,
	44=>8,
	45=>8,
	46=>8,
	47=>8,
);
/** エリア都道府県ハッシュ	*/
$GLOBALS['AREA_PREFECTURE_HASH']	= array();
foreach( $GLOBALS['PREFECTURE_AREA_HASH'] as $key => $value ) {
	if( !isset($GLOBALS['AREA_PREFECTURE_HASH'][$value])
		|| !is_array($GLOBALS['AREA_PREFECTURE_HASH'][$value])) {
		$GLOBALS['AREA_PREFECTURE_HASH'][$value]	= array();
	}
	array_push($GLOBALS['AREA_PREFECTURE_HASH'][$value],$key);
}

/** 携帯メールアドレスドメイン名	*/
$GLOBALS['MOBILE_MAIL_DOMAIN_ARRAY'] = array(
	'docomo.ne.jp'
	,'ezweb.ne.jp'
	,'yy.ezweb.ne.jp'
	,'t.vodafone.ne.jp'
	,'d.vodafone.ne.jp'
	,'h.vodafone.ne.jp'
	,'c.vodafone.ne.jp'
	,'r.vodafone.ne.jp'
	,'k.vodafone.ne.jp'
	,'n.vodafone.ne.jp'
	,'s.vodafone.ne.jp'
	,'q.vodafone.ne.jp'
	,'softbank.ne.jp'
	,'disney.ne.jp'
	,'i.softbank.jp'
);

/** 曜日配列	*/
$GLOBALS['WEEK_DAY_NAME_ARRAY']	= array( '日','月','火','水','木','金','土' );

/** プログラム生成ファイルパーミッション @deprecated 1.1.00 - 2010/06/30	*/
define ( 'SPIDER_FILE_CREATE_PERMITTION',		SPIDER_PERMITTION_PUBLIC_FILE );
/** プログラム生成フォルダパーミッション @deprecated 1.1.00 - 2010/06/30	*/
define ( 'SPIDER_FOLDER_CREATE_PERMITTION',	SPIDER_PERMITTION_PUBLIC_FOLDER );

/** 会員種別ごとのURI拒否設定	*/
$GLOBALS['MEMBER_CLASS_DENY_URIS']	= array(
	'0'	=> array(),
	'1'	=> array(),
);
/** ラベル会員情報	*/
$GLOBALS['MEMBER_PERSONAL_LABEL']	= '顧客';
/** ラベル注文	*/
$GLOBALS['SHOPPING_LABEL_ORDER']	= '注文';
/** ラベル商品	*/
$GLOBALS['SHOPPING_LABEL_PRODUCT']	= '商品';
/** ラベル商品	*/
$GLOBALS['SHOPPING_LABEL_PRODUCT_UNIT']	= '販売単位';
?>