<?php
/**
 * 形態絵文字変換指示タグ
 * 
 * 記述方法 : {mobile-pict-char:変換前記述キャリア}
 * 
 * 【返還前記述キャリア】
 * 変換元を指定するにはmobile/rulesに変換用ハッシュファイルが必要です。
 * docomou  ... DoCoMo ユニコード 16進数表記HTML
 * docomos  ... DoCoMo Shift-JIS  16進数表記HTML
 * au       ... au &lt;img        localsrcタグ
 * softbank ... softbank          16進数表記コード
 * 
 * 【変換用ハッシュファイルの準備】
 * 以下のファイル名でPHPファイルを用意し、内部にハッシュを記述してください。
 * [返還前指定キャリア]2[変換後指定キャリア].inc.php
 * 
 */
require_once(dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'spider'
	.DIRECTORY_SEPARATOR.'tags'
	.DIRECTORY_SEPARATOR.'TagBase.class.php');
require_once(dirname(__FILE__)
	.DIRECTORY_SEPARATOR.'PictCharConverter.class.php');
class util_mobile_PictChar extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function util_mobile_PictChar() {
		$this->priority	= 100;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){

		$from					= 'docomou';
		$vars_tags_aray			= array();
		if( preg_match_all( '/\\{mobile\\\\-pict\\\\-char\\:[^\\}]*?}/'
			, $result_strings
			, $vars_tags_aray
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $vars_tags_aray as $vars_tags ) {
				foreach ( $vars_tags as $vars_tag ) {
					$from	= preg_replace( '/\\{\\{mobile\\\\-pict\\\\-char\\\\:/','', $vars_tag );
					$from	= preg_replace( '/\\}$/','', $from );
					$from	= str_replace("'","",$from);
					$from	= trim(str_replace('"','',$from));
					$result_strings = str_replace( $vars_tag, '', $result_strings );
				}
			}
			// 指定された変換元から自動で変換
			$result_strings	= util_mobile_PictCharConverter::convert( $result_strings, $from, 'auto' );
		} else {
			$from	= 'docomou';
		}
		// src書き換え
		$process_code = 'require_once("'.str_replace('\\','\\\\',DIR_PATH_LIB
			.DIRECTORY_SEPARATOR.'util'
			.DIRECTORY_SEPARATOR.'mobile'
			.DIRECTORY_SEPARATOR.'PictCharConverter.class.php' ).'");'."\n";
		$process_code .= '$outstr = util_mobile_PictCharConverter::convert( $outstr, "'.$from.'" );'."\n";
		
		if( !is_array($creator->convert_view_process_hash) ){
			$creator->convert_view_process_hash	= array();
		}
		if( !isset($creator->convert_view_process_hash[$this->priority])
			|| !is_array($creator->convert_view_process_hash[$this->priority]) ){
			$creator->convert_view_process_hash[$this->priority]	= array();
		}
		array_push( $creator->convert_view_process_hash[$this->priority], $process_code );
	}
}
?>