<?php
/*
 * system/tools/notify/mailbody/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'define.inc.php');
/**
 * パスワードリマインダ文章変更モジュール
 * 
 * @package system
 * @subpackage tools
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_tools_notify_mailbody_Confirm extends system_login_ModuleBase {
	
	function system_tools_notify_mailbody_Confirm(){
	}
	function execute( & $request ) {
		
		$agent					= trim(stripslashes( $_GET['agent'] ));		
		if( 'mobile' != $agent ) {
			$agent	= 'default';
		}
		$sessionObjectName		= 'system.tools.notify.mailbody.modify.object.'.$agent;
		$sessionConfirmName		= 'system.tools.notify.mailbody.modify.confirm.'.$agent;

		// 値をハッシュに格納
		$mailHash['subject']	= trim(stripslashes($_POST['subject']));
		$mailHash['body']		= trim(stripslashes($_POST['body']));
		
		// 入力値の点検
		if ( strlen($mailHash['subject']) == 0 ) {
			$request->addLocaledError('system.error.tools.notify.mail.subjectrequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( strlen($mailHash['subject']) > 300 ) {
			// TODO:100文字？
			$request->addLocaledError('system.error.tools.notify.mail.subjectoverlength',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if ( strlen($mailHash['body']) == 0 ) {
			$request->addLocaledError('system.error.tools.notify.mail.bodyrequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( strlen($mailHash['body']) > 15000 ) {
			// TODO:5000文字？
			$request->addLocaledError('system.error.tools.notify.mail.bodyoverlength',SPIDER_LOG_LEVEL_ERROR,array());
		}

		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName, $mailHash);

		$request->setAttribute('system.tools.notify.mailbody.agent', $agent);
		$request->setAttribute('system.tools.notify.mailbody.mail_hash', $mailHash);
	}
}
?>