<?php
/*
 * system/package/install/Session.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : systemパッケージ/パッケージインストーラ 入力フォーム表示用アクションモジュールクラス
 * 
 * spiderのページから呼び出して実行します。
 * 
 * @package system
 * @subpackage package
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 * @abstract
 */
class system_package_install_Session extends system_login_ModuleBase {
	
	function system_package_install_Session(){
		// インストール済みパッケージ読み込みモジュールを先に実行
		array_push($this->require_module_array,'system.package.LoadList');
	}
	function execute( & $request ) {
		$targetPackageId	= $request->getParam('sitpi','get');
		$command			= $request->getParam('cmd','get');
		if( is_null($targetPackageId) || strlen($targetPackageId) == 0 ) {
			$targetPackageId	= 'system';
		}
		$targetPackageConfigObject	= null;
		if( $request->existsSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_OBJECT_HASH) ) {
			// セッションに登録されているなら
			$installPackageConfigObjectHash	= $request->getSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_OBJECT_HASH,SPIDER_SESSION_SCOPE_GLOBAL);
			// 対象パッケージID配列の初期化
			$installPackageIdArray				= array();
			foreach( $installPackageConfigObjectHash as $packageId => $packageConfigObject ) {
				array_push( $installPackageIdArray, $packageId );
			}
			$targetPackageConfigObject		= $installPackageConfigObjectHash[$targetPackageId];
			if( is_array($installPackageConfigObjectHash) ) {
				// 要求IDの配列を初期化
				$installPackageIdArray		= array();
				// セッションに確認済みオブジェクト配列があるならID配列を作成する
				foreach( $installPackageConfigObjectHash as $installPackageObject ) {
					array_push( $installPackageIdArray, $installPackageObject->getPackageId() );
				}
			}
		}
		$request->setAttribute('system.package.install.target_package_object',$targetPackageConfigObject);
		$request->setAttribute('system.package.install.install_id_array',$installPackageIdArray);
		$request->setAttribute('system.package.install.install_object_hash',$installPackageConfigObjectHash);
	}
}
?>