<?php
/*
 * system/package/install/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Form.class.php');
/**
 * spider : systemパッケージ/パッケージインストーラ 更新実行用アクションモジュールクラス
 * 
 * spiderのページから呼び出して実行します。
 * 
 * @package system
 * @subpackage package
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 * @abstract
 */
class system_package_install_Execute extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function system_package_install_Execute(){
		// インストール済みパッケージ読み込みモジュールを先に実行
		array_push($this->require_module_array,'system.package.LoadList');
	}
	function execute( & $request ) {
		$confirmResult					= $request->getSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_CONFIRM_RESULT,SPIDER_SESSION_SCOPE_GLOBAL);
		$installPackageConfigObjectHash	= $request->getSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_OBJECT_HASH,SPIDER_SESSION_SCOPE_GLOBAL);
		$totalCount						= $request->getSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_TOTAL_COUNT,SPIDER_SESSION_SCOPE_GLOBAL);
		// インストール済みパッケージID配列
		$installedPackageIdArray	= $request->getAttribute('system.package.installedPackageIdArray');
		if( 'OK' != $confirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_OBJECT_HASH,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_CONFIRM_RESULT,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_TOTAL_COUNT,SPIDER_SESSION_SCOPE_GLOBAL);
		} else if ( !is_array($installPackageConfigObjectHash) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_OBJECT_HASH,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_CONFIRM_RESULT,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_TOTAL_COUNT,SPIDER_SESSION_SCOPE_GLOBAL);
		} else {
			// 総数の確認
			if( is_null( $totalCount ) || preg_match('/^[0-9]+$/',$totalCount) == 0 ) {
				// 数値でないなら総数を登録
				$totalCount	= count($installPackageConfigObjectHash);
			}
			// 配列の最初のオブジェクトからインストール・更新を行う
			$packageConfigObject	= array_shift($installPackageConfigObjectHash);
			if( $packageConfigObject->isInstall() ) {
				// インストール済みなら更新処理
				if( $packageConfigObject->save( $request ) ) {
				} else {
					$request->addLocaledError('system.error.writer.save',SPIDER_LOG_LEVEL_ERROR,array(''));
				}
			} else {
				// インストールされていないならインストール
				if( $packageConfigObject->install( $request ) ) {
					if( $packageConfigObject->save( $request ) ) {
					} else {
						$request->addLocaledError('system.error.writer.save',SPIDER_LOG_LEVEL_ERROR,array(''));
					}
				}
			}

			// 処理後の残りカウント
			$remain_count	= count($installPackageConfigObjectHash);
			if( $remain_count == 0 ) {
				// 残り数0なら終了
				$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_OBJECT_HASH,SPIDER_SESSION_SCOPE_GLOBAL);
				$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_CONFIRM_RESULT,SPIDER_SESSION_SCOPE_GLOBAL);
				$request->removeSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_TOTAL_COUNT,SPIDER_SESSION_SCOPE_GLOBAL);
			} else {
				// 残りがあるならセッションを再登録
				$request->setSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_OBJECT_HASH,$installPackageConfigObjectHash,SPIDER_SESSION_SCOPE_GLOBAL);
				$request->setSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_CONFIRM_RESULT,$confirmResult,SPIDER_SESSION_SCOPE_GLOBAL);
				$request->setSession(SYSTEM_SESSION_NAME_PACKAGE_INSTALL_TOTAL_COUNT,$totalCount,SPIDER_SESSION_SCOPE_GLOBAL);
			}
			$request->setAttribute('system.package.install.remain_count',$remain_count);
			$request->setAttribute('system.package.install.total_count',$totalCount);
			$request->setAttribute('system.package.install.install_object_hash',$installPackageConfigObjectHash);
		}
		

	}
}
?>