<?php
/*
 * system/login/Require.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
/**
 * spider : ログイン要求用アクションモジュールクラス
 * 
 * 本モジュールをページ側でコールすると、該当するページ及びディレクトリ内で
 * ログイン必須となります。
 * 
 * @package system
 * @subpackage login
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_login_Require extends system_login_ModuleBase {
	function system_login_Require(){
	}
	function execute( & $request ) {
		// ログインフラグ
		$loginInformationObject	= null;
		$is_login		= $this->isLogin( $request );
		if( $is_login === true ) {
			$loginInformationObject	= $this->getLoginUserObject( $request );
			$request->setAttribute('system.login.logininformation', $loginInformationObject );
		}
		$request->setAttribute('system.login.is_login', $is_login );

		// アクセス権限の確認
		if( $is_login && is_a($loginInformationObject,'system_login_AbstractUser') ) {
			// ログインしているなら指定URIへのアクセス権限があるか確認する
			if( $loginInformationObject->hasUriPermittion(SPIDER_URI_APP) ) {
				// URIへのアクセス権限があるなら
			} else {
				$request->addLocaledError('system.error.login.user.noauth',SPIDER_LOG_LEVEL_ERROR,array());
				// アクセス権限がないならエラーページにリダイレクト
				$this->pageRedirect( $request, 'noauth.php' );
			}
		} else {
			// ログインしていないならセッションにリクエストされたURIを登録
			if( preg_match('/\\.js\\.php$/',SPIDER_URI_APP) == 0 ) {
				$request->setSession( SYSTEM_SESSION_NAME_LAST_LOGIN_ERROR_URI
					, SPIDER_URI_REQUEST
					, SPIDER_SESSION_SCOPE_GLOBAL );
			}
			$request->addLocaledError('system.error.login.user.requirelogin',SPIDER_LOG_LEVEL_ERROR,array());
			// nologin.phpファイルへリダイレクト
			$this->pageRedirect( $request, 'nologin.php' );
		}
		return;
	}
}
?>