<?php
/*
 * framework-spider
 * spider/HttpOutput.class.php
 * 
 * グローバル関数定義ファイル
 * spiderで利用するグローバル関数を定義するファイルです
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'BuildInformation.class.php' );
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'Builder.class.php');
require_once(dirname(dirname( __FILE__ )).DIRECTORY_SEPARATOR.'util'.DIRECTORY_SEPARATOR.'LockProcess.class.php' );
/**
 * HTTP出力を行うクラスです。
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved.<br /> 
 * URL         : http://sourceforge.jp/projects/frameworkspider/<br />
 * Mail        : frameworkspider-dev@lists.sourceforge.jp<br />
 * Auther      : Masanori Nakashima<br />
 * Modifier    : Masanori Nakashima<br />
 * Last Updated: 2010.11.10<br />
 * 
 * @package spider
 * @version 1.2.00
 * @copyright Copyright(c)2010, Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 * @author Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 * @access public
 */
class spider_HttpOutput {

	/**
	 * コンストラクタ
	 * @param $template_foler_path テンプレートファイルのルートディレクトリ
	 */	
	function spider_HttpOutput() {
	}
	/**
	 * リクエストの出力
	 * @param $controller モジュールを実行するspider_Controllerオブジェクト
	 * @param $request_object spider_HttpRequestオブジェクト
	 */
	function output( $controller, & $request ) {

		// 互換性
		$request_object				= & $request;
		
		// ビルド情報クラスの作成
		$build_information_object	= new spider_BuildInformation();
		
		// ユーザーエージェント分類をリクエストにセット
		$request->setAttribute('spider.access_agent_class',$build_information_object->agent_class);
		$request->agentClass	= $build_information_object->agent_class;
		
		// ビルドファイルパスを取得
		$build_file_path	= $build_information_object->getAgentPageBuildFilePath();
		$build_confirm_path	= $build_file_path.'.build.php';
		
		// 指定ファイルに対してロックオブジェクト作成
		$bin_lock_name		= str_replace('/','_S_',str_replace('/','_S_',$build_information_object->execute_file_path));
		$lock_obj			= new util_LockProcess($bin_lock_name);

		// ファイルとテンプレートの更新を確認
		$build				= false;
		if( file_exists( $build_confirm_path )
		&& filemtime($build_confirm_path) > filemtime(__FILE__)
		&& filemtime($build_confirm_path) > filemtime(SPIDER_BASE_PATH.DIRECTORY_SEPARATOR.'spider.inc.php') ) {
			// ビルド確認ファイルが存在するなら実行してビルド済みファイルが古くないか確認
			require_once( $build_confirm_path );
			if( $build ) {
				// ビルドファイルが古いならビルドファイルを削除
				if( $lock_obj->lock() ) {
					if( file_exists($build_file_path) ) {
						@unlink( $build_file_path );
					}
					if( file_exists($build_confirm_path) ) {
						@unlink( $build_confirm_path );
					}
				} else {
					$lock_obj->release();
					$this->exitWithCoreError();
				}
			} else if( $lock_obj->wait() ) {
				require_once( $build_file_path );
				return;
			} else {
				$this->exitWithCoreError();
			}
		} else if( file_exists( $build_file_path ) ) {
			// ビルド確認ファイルが存在しないならビルドファイルも削除する
			if( $lock_obj->lock() ) {
				if( file_exists($build_file_path) ) {
					@unlink( $build_file_path );
				}
			} else {
				$lock_obj->release();
				$this->exitWithCoreError();
			}
		} else {
			if( $lock_obj->lock() ) {
				if( file_exists($build_file_path) ) {
					@unlink( $build_file_path );
				}
				if( file_exists($build_confirm_path) ) {
					@unlink( $build_confirm_path );
				}
			} else {
				$lock_obj->release();
				$this->exitWithCoreError();
			}
		}

		// 実行ファイル作成オブジェクト
		$builder_object	= new spider_Builder();
		
		// 実行ファイル作成
		$builder_object->createBinFile( $build_information_object );
		$lock_obj->release();
		
		// 実行ファイル実行
		require( $build_file_path );

		return;
	}
	/**
	 * コアエラーが起こった場合にエラーメッセージを出力して終了します。
	 */
	function exitWithCoreError() {
		spider_HttpOutput::exitWithMessage($GLOBALS['spider.messages']['spider.httpoutput.busy']);
	}
	/**
	 * エラーメッセージとともに処理を終了します
	 * @param string $message
	 * @static
	 */
	function exitWithMessage( $message ) {
		header('Content-Type: text/html;charset=UTF-8');
		die('<html><body>Core Error: '.$message.'</body></html>');
		
	}
}
?>