<?php
/*
 * shopping/setting/settlement/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'member'
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_setting_settlement_Execute extends system_login_ModuleBase {
	function shopping_setting_settlement_Execute() {
		array_push($this->require_module_array,'shopping.order.settlement.LoadListExists');
	}
	function execute( & $request ) {
		$settleMethodObjectArray	= $request->getAttribute('shopping.order.settlement.methodExistsObjectArray');
		$settleMethodObjectHash		= array();
		foreach( $settleMethodObjectArray as $settleObject ) {
			$settleMethodObjectHash[$settleObject->getMethodNumber()]	= $settleObject;
		}
		$enableHash				= $_POST['enable'];
		$canMobileHash			= $_POST['canMobile'];
		$viewNameHash			= $_POST['viewName'];
		$statusReadyHash		= $_POST['statusReady'];
		$statusNomalHash		= $_POST['statusNomal'];
		$statusErrorHash		= $_POST['statusError'];
		$statusSettleHash		= $_POST['statusSettle'];
		$feeTypeHash			= $_POST['feeType'];
		$feeValueHash			= $_POST['feeValue'];
		$explanationHash		= $_POST['explanation'];
		$mailCommentHash		= $_POST['mailComment'];
		$mailOrderHash			= $_POST['mailOrder'];
		$attentionHash			= $_POST['attention'];
		$settingValuesHash		= $_POST['settingValues'];
		$priceMinimumHash		= $_POST['priceMinimum'];
		$priceMaximumHash		= $_POST['priceMaximum'];
		$memberClassArrayHash	= $_POST['memberClassArray'];
		
		// 状態
		if( !is_array($enableHash) ) {
			$request->addLocaledError('shopping.error.common.invalidstatus',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			foreach( $enableHash as $number => $enable ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( preg_match('/^([tT](|[rR][uU][eE])|[yY](|[eE][sS])|1)$/',$enable) > 0 ) {
					$settleMethodObjectHash[$number]->enable	= true;
				} else {
					$settleMethodObjectHash[$number]->enable	= false;
				}
			}
		}

		// 携帯電話利用可否
		if( !is_array($canMobileHash) ) {
			$request->addLocaledError('shopping.error.common.invalidstatus',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			foreach( $canMobileHash as $number => $canMobile ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( preg_match('/^([tT](|[rR][uU][eE])|[yY](|[eE][sS])|1)$/',$canMobile) > 0 ) {
					$settleMethodObjectHash[$number]->canMobile	= true;
				} else {
					$settleMethodObjectHash[$number]->canMobile	= false;
				}
			}
		}

		// 表示名
		if( !is_array($viewNameHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.invalidviewname',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else {
			foreach( $viewNameHash as $number => $viewName ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( strlen(trim($viewName)) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.requireviewnamet',SPIDER_LOG_LEVEL_ERROR,array($name));
				} else if( strlen(trim($viewName)) > 90 ) {
					$request->addLocaledError('shopping.error.setting.settle.invalidviewnamet',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->viewName	= $viewName;
			}
		}

		// 処理前後の状態 決済動作前
		if( !is_array($statusReadyHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.sts.01.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $statusReadyHash as $number => $statusReady ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( strlen(trim($statusReady)) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.sts.01.require',SPIDER_LOG_LEVEL_ERROR,array($name));
				} else if( !array_key_exists($statusReady,$GLOBALS['SHOPPING_ORDER_STATUS_HASH']) ) {
					$request->addLocaledError('shopping.error.setting.settle.sts.01.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->statusReady	= $statusReady;
			}
		}

		// 処理前後の状態 正常終了時
		if( !is_array($statusNomalHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.sts.02.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $statusNomalHash as $number => $statusNomal ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( strlen(trim($statusNomal)) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.sts.02.require',SPIDER_LOG_LEVEL_ERROR,array($name));
				} else if( !array_key_exists($statusNomal,$GLOBALS['SHOPPING_ORDER_STATUS_HASH']) ) {
					$request->addLocaledError('shopping.error.setting.settle.sts.02.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->statusNomal	= $statusNomal;
			}
		}

		// 処理前後の状態 異常終了時
		if( !is_array($statusErrorHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.sts.03.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $statusErrorHash as $number => $statusError ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( strlen(trim($statusError)) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.sts.03.require',SPIDER_LOG_LEVEL_ERROR,array($name));
				} else if( !array_key_exists($statusError,$GLOBALS['SHOPPING_ORDER_STATUS_HASH']) ) {
					$request->addLocaledError('shopping.error.setting.settle.sts.03.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->statusError	= $statusError;
			}
		}

		// 正常終了時の決済状態
		if( !is_array($statusSettleHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.stss.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $statusSettleHash as $number => $statusSettle ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( strlen(trim($statusSettle)) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.stss.require',SPIDER_LOG_LEVEL_ERROR,array($name));
				} else if( !array_key_exists($statusSettle,$GLOBALS['SHOPPING_ORDER_STATUS_SETTLE_HASH']) ) {
					$request->addLocaledError('shopping.error.setting.settle.stss.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->statusSettle	= $statusSettle;
			}
		}

		// 手数料タイプ
		if( !is_array($feeTypeHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.ochg.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $feeTypeHash as $number => $feeType ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				$feeType	= mb_convert_kana(trim($feeType),'a');
				if( strlen(trim($feeType)) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.ochg.require',SPIDER_LOG_LEVEL_ERROR,array($name));
				} else if( preg_match('/^(0|1|2)$/',$feeType) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.ochg.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->feeType	= $feeType;
			}
		}

		// 手数料値
		if( !is_array($feeValueHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.ochgv.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $feeValueHash as $number => $feeValue ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				$feeValue	= mb_convert_kana(trim($feeValue),'a');
				if( strlen(trim($feeValue)) == 0 ) {
				} else if( preg_match('/^[0-9]{1,7}$/',$feeValue) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.ochg.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->feeValue	= $feeValue;
			}
		}

		// 条件 金額下限
		if( !is_array($priceMinimumHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.condmin.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $priceMinimumHash as $number => $priceMinimum ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				$priceMinimum	= mb_convert_kana(trim($priceMinimum),'a');
				if( strlen(trim($priceMinimum)) == 0 ) {
				} else if( preg_match('/^[0-9]{1,7}$/',$priceMinimum) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.condmin.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->priceMinimum	= $priceMinimum;
			}
		}

		// 条件 金額上限
		if( !is_array($priceMaximumHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.condmax.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $priceMaximumHash as $number => $priceMaximum ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				$priceMaximum	= mb_convert_kana(trim($priceMaximum),'a');
				if( strlen(trim($priceMaximum)) == 0 ) {
				} else if( preg_match('/^[0-9]{1,7}$/',$priceMaximum) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.condmax.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->priceMaximum	= $priceMaximum;
			}
		}

		// 条件 対象会員
		if( !is_array($memberClassArrayHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.condmem.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $memberClassArrayHash as $number => $memberClassArray ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( !is_array($memberClassArray) ) {
					$request->addLocaledError('shopping.error.setting.settle.condmem.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				} else {
					$settleMethodObjectHash[$number]->memberClassArray	= $memberClassArray;
					foreach( $memberClassArray as $val ) {
						if( !array_key_exists( $val, $GLOBALS['MEMBER_MEMBER_CLASS_HASH'] ) ) {
							$request->addLocaledError('shopping.error.setting.settle.condmem.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
						}
					}
				}
			}
		}

		// 説明文
		if( !is_array($explanationHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.explain.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $explanationHash as $number => $explanation ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( strlen(trim($explanation)) == 0 ) {
					$request->addLocaledError('shopping.error.setting.settle.explain.require',SPIDER_LOG_LEVEL_ERROR,array($name));
				} else if( strlen(trim($explanation)) > 6000 ) {
					$request->addLocaledError('shopping.error.setting.settle.explain.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->explanation	= stripslashes($explanation);
			}
		}

		// サンキューメール決済コメント
		if( !is_array($mailCommentHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.thkmail.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $mailCommentHash as $number => $mailComment ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( strlen(trim($mailComment)) == 0 ) {
				} else if( strlen(trim($mailComment)) > 6000 ) {
					$request->addLocaledError('shopping.error.setting.settle.thkmail.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->mailComment	= stripslashes($mailComment);
			}
		}

		// 発注メール決済コメント
		if( !is_array($mailOrderHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.ordmail.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $mailOrderHash as $number => $mailOrder ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( strlen(trim($mailOrder)) == 0 ) {
				} else if( strlen(trim($mailOrder)) > 6000 ) {
					$request->addLocaledError('shopping.error.setting.settle.ordmail.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->mailOrder	= stripslashes($mailOrder);
			}
		}

		// 注意書き
		if( !is_array($attentionHash) ) {
			$request->addLocaledError('shopping.error.setting.settle.attent.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $attentionHash as $number => $attention ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( strlen(trim($attention)) == 0 ) {
				} else if( strlen(trim($attention)) > 6000 ) {
					$request->addLocaledError('shopping.error.setting.settle.attent.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				}
				$settleMethodObjectHash[$number]->attention	= stripslashes($attention);
			}
		}

		// オプション設定
		if( !is_array($settingValuesHash) ) {
					$request->addLocaledError('shopping.error.setting.settle.opt.invalidhash',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			foreach( $settingValuesHash as $number => $settingValues ) {
				$name	= $settleMethodObjectHash[$number]->getMethodName();
				if( !is_array($settingValues) ) {
					$request->addLocaledError('shopping.error.setting.settle.opt.invalid',SPIDER_LOG_LEVEL_ERROR,array($name));
				} else {
					$settleMethodObjectHash[$number]->settingValues	= $settingValues;
					$settleMethodObjectHash[$number]->validate( $request );
				}
			}
		}
		if( !$request->isError() ) {
			// エラーがなければ保存
			foreach( $settleMethodObjectHash as $num => $settleMethodObject ) {
				if( $settleMethodObject->save( $request ) ) {
				}
			}
		} else {
		}
	}
}
?>