<?php
/*
 * shopping/promotion/ChangeStatus.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_promotion_ChangeStatus extends system_login_ModuleBase {
	function shopping_promotion_ChangeStatus(){
	}
	function execute( & $request ) {
		$dbo							= $request->getAttribute( 'dbo' );
		$promotionId					= trim(stripslashes($_POST['promotion_id']));
		$statusFlag						= trim(stripslashes($_POST['status_flag']));
		$loginUserObject				= $this->getLoginUserObject( $request );
		$shoppingPromotionObject		= spider_Controller::createObject('shopping_DaoShoppingPromotion');
		
		$shoppingPackageConfigObject	= spider_Controller::createObject('shopping_PackageConfig');
		if( $shoppingPackageConfigObject->load( $request ) ) {
		} else {
			$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array(''));
			return;
		}

		if( strlen($promotionId) == 0 ) {
			$request->addLocaledError('system.error.common.data.requireselect',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( !array_key_exists($statusFlag,$GLOBALS['SHOPPING_PROMOTION_STATUS_HASH']) ) {
			$request->addLocaledError('shopping.error.common.invalidstatus',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( false == $dbo->loadById( $shoppingPromotionObject, $promotionId ) ) {
			$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			$shoppingPromotionObject->status_flag	= $statusFlag;
			$shoppingPromotionObject->updated_date	= date('Y-m-d H:i:s');
			if( $shoppingPromotionObject->canEditData( $request, $loginUserObject ) ) {
				if( $this->lockData( $request, $shoppingPromotionObject ) ) {
					if( $dbo->update($shoppingPromotionObject,false) ) {
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
					$this->unlockData( $request, $shoppingPromotionObject );
				} else {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}
		$request->setAttribute('shopping.promotion.promotion_object',		$shoppingPromotionObject);
	}
}
?>