<?php
/*
 * shopping/product/unit/status/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_product_unit_status_Execute extends system_login_ModuleBase {
	
	function shopping_product_unit_status_Execute(){
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$unitNumber					= stripslashes( $_GET['shpun'] );
		$sessionObjectName			= 'shopping.product.unit.status.modify.object.'.$unitNumber;
		$sessionConfirmName			= 'shopping.product.unit.status.modify.confirm.'.$unitNumber;
		$loginUserObject			= $this->getLoginUserObject( $request );
		$shoppingProductUnitObject	= $request->getSession($sessionObjectName);
		$confirmResult				= $request->getSession($sessionConfirmName);
		$compareShoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');

		if( !$request->isError() ) {
			// パッケージ設定読み込み
			$shoppingPackageConfigObject	= spider_Controller::createObject('shopping_PackageConfig');
			if( $shoppingPackageConfigObject->load( $request ) ) {
			} else {
				$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
				return;
			}
			
			if( 'OK' != $confirmResult ) {
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			} else if ( get_class($shoppingProductUnitObject) != get_class($compareShoppingProductObject) ){
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				if( !$request->isError() ) {
					// ログインしている場合としていない場合の振り分け
					if( $this->isLogin( $request ) ) {
						// ログインしているなら編集ユーザーのユニークIDを設定
						$shoppingProductUnitObject->modifier_id	= $loginUserObject->getUniqueId();
					}
					// エラーがないならデータ登録と更新
					if( strlen(trim($shoppingProductUnitObject->unit_number)) > 0 ) {
						// データ番号が設定済みなら更新
						if( !$shoppingProductUnitObject->canEditData( $request, $loginUserObject ) ) {
							$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
						} else if ( !$shoppingProductUnitObject->canEditStatus( $request, $loginUserObject ) ) {
							$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
						} else {
							if( $this->lockData( $request, $shoppingProductUnitObject ) ) {
								// 編集ロックを再取得できたら更新
								$shoppingProductUnitObject->updated_date	= date('Y-m-d H:i:s');
								$errors	= array();
								if( $dbo->update($shoppingProductUnitObject,false) ) {
								} else {
									$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
								}
								$this->unlockData( $request, $shoppingProductUnitObject );
							} else {
								$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						}
					} else {
						// データ番号がないならエラー
						$request->addLocaledError('shopping.error.product.unit.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('shopping.product.unit.unit_object',		$shoppingProductUnitObject);
	}
}
?>