<?php
/*
 * shopping/product/MemberClass.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-11-15
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_product_MemberClass extends system_login_ModuleBase {
	function shopping_product_MemberClass(){
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$productNumber			= $request->getParam('product_number','post');
		$memberViewableArray	= $request->getParam('member_viewable','post','array');
		$memberPurchasableArray	= $request->getParam('member_purchasable','post','array');
		$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		$loginUserObject		= $this->getLoginUserObject( $request );
		if( preg_match('/^[0-9]{1,6}$/',$productNumber) == 0 ) {
			$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			// データ番号が指定されているなら編集の為読み込み
			if( $dbo->loadByNumber( $shoppingProductObject, $productNumber ) ) {
				if( false === $this->lockData( $request, $shoppingProductObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					if ( !$shoppingProductObject->canEditData( $request, $loginUserObject ) ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					} else {
						// 問題がなければ、状態をオブジェクトにセット
						$shoppingProductObject->memberViewableArray		= $memberViewableArray;
						$shoppingProductObject->memberPurchasableArray	= $memberPurchasableArray;
						if( $shoppingProductObject->validate( $request ) ) {
							$shoppingProductObject->updated_date			= date('Y-m-d H:i:s');
							if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
								// 管理者ログイン以外の場合、ステータスを新規に設定
								$shoppingProductObject->status_flag = 0;
							}
							// 問題なければ更新
							if( $dbo->update($shoppingProductObject,false) ) {
							} else {
								$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
								}
						}
					}
					$this->unlockData( $request, $shoppingProductObject );
				}
			} else {
				$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		$request->setAttribute('shopping.product.product_object',	$shoppingProductObject);
	}
}
?>