<?php
/*
 * shopping/product/Category.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-11-15
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_product_Category extends system_login_ModuleBase {
	
	function shopping_product_Category(){
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$productNumber		= $request->getParam('product_number','post');
		$categoryOrder		= $request->getParam('category_order','post');
		$categoryId			= $request->getParam('category_id','post');
		$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		$shoppingCategoryObject	= spider_Controller::createObject('shopping_DaoShoppingCategory');
		$loginUserObject		= $this->getLoginUserObject( $request );
		if( preg_match('/^[0-9]{1,6}$/',$productNumber) == 0 ) {
			$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( preg_match('/^[0-9]{1,3}$/',$categoryOrder) == 0 ) {
			$request->addLocaledError('shopping.error.category.product.invalidorder',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( strlen($categoryId) > 0
		&& $dbo->loadById($shoppingCategoryObject,$categoryId,false) === false ) {
			$request->addLocaledError('shopping.error.category.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			// データ番号が指定されているなら編集の為読み込み
			if( $dbo->loadByNumber( $shoppingProductObject, $productNumber ) ) {
				if( false === $this->lockData( $request, $shoppingProductObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					if ( !$shoppingProductObject->canEditData( $request, $loginUserObject ) ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					} else if( is_array($shoppingProductObject->categoryIdArray)
					&& in_array($categoryId,$shoppingProductObject->categoryIdArray)) {
						$request->addLocaledError('shopping.error.category.product.joined',SPIDER_LOG_LEVEL_FATAL,array(''));
					} else {
						// 問題がなければ、状態をオブジェクトにセット
						if( !is_array($shoppingProductObject->categoryIdArray) ) {
							$shoppingProductObject->categoryIdArray	= array();
						}
						if( strlen($categoryId) > 0 ) {
							$shoppingProductObject->categoryIdArray[$categoryOrder]	= $categoryId;
						} else {
							unset($shoppingProductObject->categoryIdArray[$categoryOrder]);
						}
						$shoppingProductObject->updated_date					= date('Y-m-d H:i:s');
						if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
							// 管理者ログイン以外の場合、ステータスを新規に設定
							$shoppingProductObject->status_flag = 0;
						}
						// 問題なければ更新
						$dbo->update($shoppingProductObject,false);
					}
					$this->unlockData( $request, $shoppingProductObject );
				}
			} else {
				$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		$request->setAttribute('shopping.product.product_object',	$shoppingProductObject);
	}
}
?>