<?php
/*
 * shopping/order/step/ConfirmOptions.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-04
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php' );
class shopping_order_step_ConfirmOptions extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_step_ConfirmOptions() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
		array_push($this->require_module_array,'shopping.order.step.ConfirmStock');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		// カートオブジェクトの取得
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		$redirect		= $request->getParam('redirect','post');
		// オプション入力のメンバセットと妥当性検査
		$shoppingOrderObject->validatePostOptions( $request );
		$shoppingOrderObject->calculated	= false;
		// エラーがある場合は前のページにリダイレクトを設定
		if( $request->isError()
		&& preg_match('/^([fF](|[aA][lL][sS][eE])|[nN][oO](|[nN][eE]))$/',$redirect) == 0 ) {
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_OPTIONS);
			if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
				$request->redirectTo($_SERVER['HTTP_REFERER']);
			} else if( preg_match('/^\\.\\//',trim($_POST['referer'])) > 0 ) {
				$request->redirectTo(trim($_POST['referer']));
			}
		} else {
			$confirmResult	= 'OK';
			$shoppingOrderObject->columnErrorHash	= array();
			$request->setSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_OPTIONS,$confirmResult);
		}
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
}
?>