<?php
/*
 * shopping/order/step/ConfirmItemOptions.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-04
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php' );
class shopping_order_step_ConfirmItemOptions extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_step_ConfirmItemOptions() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
		array_push($this->require_module_array,'shopping.order.step.ConfirmStock');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		// カートオブジェクトの取得
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		$redirect		= $request->getParam('redirect','post');
		// 項目用オプションのチェックと取得
		$itemOptionNames		= array();
		$itemOptionValues		= array();
		if( isset($_POST['item_option_names']) && is_array($_POST['item_option_names']) ) {
			$itemOptionNames	= $_POST['item_option_names'];
		}
		if( isset($_POST['item_option_values']) && is_array($_POST['item_option_values']) ) {
			$itemOptionValues	= $_POST['item_option_values'];
		}
		if(is_array($shoppingOrderObject->columnErrorHash['options'])){
			unset($shoppingOrderObject->columnErrorHash['options']);
		}
		foreach( $shoppingOrderObject->shoppingOrderAddressObjectArray as $addressOrder => $addressObject ) {
			$shoppingOrderAddressObject	= & $shoppingOrderObject->shoppingOrderAddressObjectArray[$addressOrder];
			foreach( $shoppingOrderAddressObject->shoppingOrderItemObjectArray as $itemOrder => $itemObject ) {
				$shoppingOrderItemObject = & $shoppingOrderAddressObject->shoppingOrderItemObjectArray[$itemOrder];
				if( isset($itemOptionNames[$addressOrder])
				&& is_array($itemOptionNames[$addressOrder])
				&& isset($itemOptionValues[$addressOrder])
				&& is_array($itemOptionValues[$addressOrder]) ) {
					$tItemOptionNames	= $itemOptionNames[$addressOrder];
					$tItemOptionValues	= $itemOptionValues[$addressOrder];
					if( isset($tItemOptionNames[$itemOrder])
					&& is_array($tItemOptionNames[$itemOrder])
					&& isset($tItemOptionValues[$itemOrder])
					&& is_array($tItemOptionValues[$itemOrder]) ) {
						$shoppingOrderItemObject->setOrderOption( $request, $tItemOptionNames[$itemOrder], $tItemOptionValues[$itemOrder] );
						foreach( $shoppingOrderItemObject->shoppingOrderOptionObjectArray as $optionObj ){
							if( count($optionObj->columnErrorHash)>0 && count($optionObj->columnErrorHash['option_value'])>0 ){
								if(!is_array($shoppingOrderObject->columnErrorHash)){
									$shoppingOrderObject->columnErrorHash	= array();
								}
								if(!is_array($shoppingOrderObject->columnErrorHash['options'])){
									$shoppingOrderObject->columnErrorHash['options']	= array();
								}
								foreach($optionObj->columnErrorHash['option_value'] as $msg){
									array_push($shoppingOrderObject->columnErrorHash['options'],$msg);
								}
							}
						}
					}
				}
			}
		}
		// エラーがある場合は前のページにリダイレクトを設定
		if( $request->isError() ){
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ITEMOPTIONS);
			if( preg_match('/^([fF](|[aA][lL][sS][eE])|[nN][oO](|[nN][eE]))$/',$redirect) == 0 ) {
				if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
					$request->redirectTo($_SERVER['HTTP_REFERER']);
				} else if( preg_match('/^\\.\\//',trim($_POST['referer'])) > 0 ) {
					$request->redirectTo(trim($_POST['referer']));
				}
			}
		} else {
			$confirmResult	= 'OK';
			$shoppingOrderObject->columnErrorHash	= array();
			$shoppingOrderObject->calculated	= false;
			$request->setSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ITEMOPTIONS,$confirmResult);
		}
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
}
?>