<?php
/*
 * shopping/order/settlement/MethodBankPre.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'MethodBase.class.php');
/**
 * shopping_order_settlement_MethodBankPre
 * 決済プラグイン：銀行振込(先払い)向け決済プラグインクラス
 * 
 * 銀行振込(先払い)向けの決済プラグイン実装クラスです。
 * 注文が完了した場合にデフォルトで注文状態を「新規」、決済状態を「請求済」に設定します。
 * 外部サービスとの連携は存在しません。
 * 
 */
class shopping_order_settlement_MethodOnDemand extends shopping_order_settlement_MethodBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_settlement_MethodOnDemand() {
		$this->viewName			= '現地お支払';
		$this->feeType			= 0;
		$this->feeValue			= 0;
		$this->statusSettle		= 10;
		$this->mailTemplateName	= 'claim';
		$this->mailComment	= "ご利用日時に現地でお支払いお願いいたします。\n";
		$this->mailOrder	= "";
		$this->explanation	= <<< __METHOD_EXPLANATION__
<div>
ご利用日時に現地でお支払いお願いいたします。
</div>
__METHOD_EXPLANATION__;
	}
	/**
	 * 決済方法名を取得
	 */
	function getMethodName() {
		return '現地支払決済プラグイン';
	}
	/**
	 * 決済方法固有の番号を取得します。
	 */
	function getMethodNumber() {
		return '12';
	}
}
?>