<?php
/*
 * shopping/order/settlement/MethodBankPre.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'MethodBase.class.php');
/**
 * shopping_order_settlement_MethodBankPre
 * 決済プラグイン：銀行振込(先払い)向け決済プラグインクラス
 * 
 * 銀行振込(先払い)向けの決済プラグイン実装クラスです。
 * 注文が完了した場合にデフォルトで注文状態を「新規」、決済状態を「請求済」に設定します。
 * 外部サービスとの連携は存在しません。
 * 
 */
class shopping_order_settlement_MethodBankPre extends shopping_order_settlement_MethodBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_settlement_MethodBankPre() {
		$this->viewName			= '銀行振込(先払)';
		$this->feeType			= 0;
		$this->feeValue			= 0;
		$this->statusSettle		= 10;
		$this->mailTemplateName	= 'claim';
		$this->mailComment	= "お支払い方法に銀行振込(先払)をご選択いただいています。\n下記記載の銀行口座にお振込お願いいたします。\n"
			."お振込を確認いたしましたら商品の手配をいたします。\n\n"
			."○○銀行 ○○支店 普通口座 口座番号 0000000\n"
			."○○○○株式会社";
		$this->mailOrder	= "";
		$this->explanation	= <<< __METHOD_EXPLANATION__
<div>
前払い銀行振込でのお支払いです。<br />
お振込確認後の発送とさせていただいております。<br />
お振込手数料はご負担ください。
</div>
__METHOD_EXPLANATION__;
	}
	/**
	 * 決済方法名を取得
	 */
	function getMethodName() {
		return '銀行振込(先払)決済プラグイン';
	}
	/**
	 * 決済方法固有の番号を取得します。
	 */
	function getMethodNumber() {
		return '10';
	}
}
?>