<?php
/*
 * shopping/order/option/Delete.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_option_Delete extends system_login_ModuleBase {
	function shopping_order_option_Delete() {
	}
	function execute( & $request ) {
		$searchDataId			= $request->getParam('schdi','get');
		$optionFileUri			= SHOPPING_OPTIONS_FILE_URI;
		if( preg_match('/^[0-9a-zA-Z]+$/',$searchDataId) > 0 ) {
			$optionFileUri	= dirname(SHOPPING_OPTIONS_FILE_URI).'/extoptions/'.$searchDataId;
		}
		$optionNumber			= $request->getParam('optionNumber','post');
		// 検索パッケージ連携
		if( strlen(trim($searchDataId)) > 0 ) {
			$dbo		= $request->getAttribute( 'dbo' );
			$searchDataObject	= spider_Controller::createObject('search_DaoSearchData');
			if( $dbo->loadById($searchDataObject,$searchDataId) ) {
				if( $this->isLogin( $request )
				&& $loginUserObject->getUniqueId() == $searchDataObject->owner_id
				|| SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
					$request->setAttribute('shopping.order.option.searchDataObject',$searchDataObject);
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				}
			} else {
				$request->addLocaledError('shopping.error.search.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		// オプションクラスファイルを要求
		if( $dh	= @opendir(dirname(__FILE__).DIRECTORY_SEPARATOR.'type') ) {
			while (($fileName = readdir($dh)) !== false) {
				if( preg_match('/\\.class\\.php$/',$fileName) > 0 ){
					$absolutePath	= dirname(__FILE__).DIRECTORY_SEPARATOR.'type'.DIRECTORY_SEPARATOR.$fileName;
					require_once($absolutePath);
				}
			}
		} else {
			$request->addLocaledError('shopping.error.option.loadfolder',SPIDER_LOG_LEVEL_ERROR,array());
			return false;
		}
		
		if( strlen($optionNumber) == 0 ) {
			// 番号が不正
			$request->addLocaledError('shopping.error.option.notfound',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( preg_match('/^[0-9]{1,3}$/',$optionNumber) == 0 ) {
			// 番号が不正
			$request->addLocaledError('shopping.error.option.notfound',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			$strings	= system_DataFileWriter::getContents( $request, $optionFileUri );
			$optionHash	= unserialize($strings);
			if( !is_array($optionHash) ) {
				$optionHash	= array();
			}
			if( !isset($optionHash[$optionNumber]) ) {
				$request->addLocaledError('shopping.error.option.notfound',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				$optionObject	= $optionHash[$optionNumber];
				unset($optionHash[$optionNumber]);
				ksort($optionHash);
				$strings	= serialize($optionHash);
				$writer		= spider_Controller::createObject('system_DataFileWriter');
				if( $writer->open( $request, $optionFileUri, 'w' ) ) {
					$writer->write( $strings );
					$writer->close( $request );
				} else {
					$request->addLocaledError('system.error.common.file.openw',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
				$request->setAttribute('shopping.order.option.optionObject',$optionObject);
			}
		}
	}
}
?>