<?php
/*
 * shopping/flag/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_flag_LoadList extends system_login_ModuleBase {
	
	function shopping_flag_LoadList() {
	}
	function execute( & $request ) {
		
		$dbo				= $request->getAttribute( 'dbo' );
		
		// 検索条件
		$conditionArray	= array();
		// 状態フラグ
		$str	= TABLE_NAME_SHOPPING_PRODUCT_FLAG.'.status_flag<200';
		array_push( $conditionArray, $str );

		// 条件整理
		$condition_string	= '';
		if( count( $conditionArray ) > 0 ) {
			$condition_string	= ' WHERE ( ' . implode(' ) AND ( ', $conditionArray) . ' )';
		}
		
		$sql	= 'SELECT * '
			. ' FROM ' . TABLE_NAME_SHOPPING_PRODUCT_FLAG
			. $condition_string
			. ' ORDER BY '
			. TABLE_NAME_SHOPPING_PRODUCT_FLAG . '.order_number ASC'
			. ',' . TABLE_NAME_SHOPPING_PRODUCT_FLAG . '.flag_number ASC'
		;
		$flagObjectArray = array();
		$shoppingProductFlagObject = spider_Controller::createObject('shopping_DaoShoppingProductFlag');
		$result	= $dbo->queryAll( $sql, $shoppingProductFlagObject, true, false );
		if ( $result === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			foreach ( $result as $flagObject ) {
				$flagObjectArray[$flagObject->flag_id] = $flagObject;
			}
		}
		$request->setAttribute( 'shopping.flag.flag_object_array', $flagObjectArray );
	}
}
?>