<?php
/*
 * member/member/point/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント入力確認用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_point_Confirm extends system_login_ModuleBase {
	function member_member_point_Confirm() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= stripslashes( $_GET['mi'] );
		$sessionObjectName		= 'member.member.point.modify.object.'.$memberId;
		$sessionConfirmName		= 'member.member.point.modify.confirm.'.$memberId;
		$memberObject			= spider_Controller::createObject('member_DaoMember');
		$compareMemberObject	= spider_Controller::createObject('member_DaoMember');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		
		if( strlen(trim($memberId)) > 0 ) {
			// ログインIDが指定されているなら編集の為読み込み
			if( $dbo ->loadById( $memberObject, $memberId ) ) {
				// 読み込めたら編集可能か確認
				if( $memberObject->canEditData( $request, $loginUserObject ) ) {
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					return false;
				}
				// 読み込めたらロック状態を確認する
				$this->lockData( $request, $memberObject );
			} else {
				$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		}
		// member_idが設定済みならロック処理
		if( strlen($memberObject->member_id ) > 0 ) {
			if( false === $this->lockData( $request, $memberObject ) ) {
				$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		}

		// 入力値のセットとチェック
		$memberObject->action_point		= trim(stripslashes($_POST['action_point']));
		$memberObject->action_label		= trim(stripslashes($_POST['action_label']));
		$memberObject->action_detail	= trim(stripslashes($_POST['action_detail']));
		if ( !preg_match( '/^(|\\-|\\+)[0-9]{1,5}$/', $memberObject->action_point ) ) {
			$request->addLocaledError('member.error.member.invalidinitpoint',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($memberObject->action_label)) > 240 ) {
			$request->addLocaledError('member.error.member.invalidpointmemo',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($memberObject->action_detail)) > 3000 ) {
			$request->addLocaledError('member.error.member.invalidpointdetail',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$memberObject);
		$request->setAttribute('member.member.point.memberObject',$memberObject);
		$request->setAttribute('member.member.point.registItems',$GLOBALS['MEMBER_REGIST_ITEM']);
		$request->setAttribute('member.member.point.requireItems',$GLOBALS['MEMBER_REQUIRE_ITEM']);
	}
}
?>