<?php
/*
 * member/member/correspond/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント入力確認用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_correspond_Confirm extends system_login_ModuleBase {
	function member_member_correspond_Confirm() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$memberId					= trim(stripslashes( $_GET['mi'] ));
		$correspondId				= trim(stripslashes( $_GET['mci'] ));
		$sessionObjectName			= 'member.member.correspond.modify.object.'.$memberId.'.'.$correspondId;
		$sessionConfirmName			= 'member.member.correspond.modify.confirm.'.$memberId.'.'.$correspondId;
		$memberObject				= spider_Controller::createObject('member_DaoMember');
		$correspondObject			= spider_Controller::createObject('member_DaoMemberCorrespond');
		$compareCorrespondObject	= spider_Controller::createObject('member_DaoMemberCorrespond');
		$loginUserObject			= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		
		if( strlen(trim($correspondId)) > 0 ) {
			// ログインIDが指定されているなら編集の為読み込み
			if( $dbo ->loadById( $correspondObject, $correspondId ) ) {
				// 対応履歴が読み込めたら会員情報を読み込み
				if( !$dbo->loadById($memberObject,$correspondObject->member_id) ) {
					$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					$correspondObject->member_id	= $memberObject->member_id;
					// 読み込めたら編集可能か確認
					if( $correspondObject->canEditData( $request, $loginUserObject ) ) {
					} else {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
						return false;
					}
					// 読み込めたらロック状態を確認する
					$this->lockData( $request, $correspondObject );
				}
			} else {
				$request->addLocaledError('member.error.correspond.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		} else if( strlen(trim($memberId)) == 0 ) {
			$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			return false;
		} else if( !$dbo->loadById($memberObject,$memberId) ){
			$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			return false;
		} else {
			// 会員情報があるなら処理続行
			$correspondObject->member_id	= $memberObject->member_id;
		}
		// $correspondIdが設定済みならロック処理
		if( strlen($correspondObject->correspond_id ) > 0 ) {
			if( false === $this->lockData( $request, $correspondObject ) ) {
				$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		}

		// 入力値のセットとチェック
		$correspondObject->status_flag			= trim(stripslashes($_POST['status_flag']));
		$correspondObject->correspond_type		= trim(stripslashes($_POST['correspond_type']));
		$correspondObject->correspond_method	= trim(stripslashes($_POST['correspond_method']));
		$correspondObject->category_id			= trim(stripslashes($_POST['category_id']));
		$correspondObject->description			= trim(stripslashes($_POST['description']));
		$correspondObject->detail_note			= trim(stripslashes($_POST['detail_note']));
		$correspondObject->start_date			= trim(stripslashes($_POST['start_date']));
		$correspondObject->correspond_date		= trim(stripslashes($_POST['correspond_date']));
		if ( preg_match( '/^(|\\-|\\+)[0-9]{1,5}$/', $correspondObject->status_flag ) == 0 ) {
			$request->addLocaledError('member.error.common.invalidstatus',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if ( preg_match( '/^(|\\-|\\+)[0-9]{1,5}$/', $correspondObject->correspond_type ) == 0 ) {
			$request->addLocaledError('member.error.correspond.invalidtype',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if ( preg_match( '/^(|\\-|\\+)[0-9]{1,5}$/', $correspondObject->correspond_method ) == 0) {
			$request->addLocaledError('member.error.correspond.invalidmethod',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($correspondObject->description)) > 240 ) {
			$request->addLocaledError('member.error.correspond.invaliddescription',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if( strlen(trim($correspondObject->detail_note)) > 30000 ) {
			$request->addLocaledError('member.error.correspond.invaliddetail',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if ( preg_match( '/^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}\\s[0-9]{2}:[0-9]{2}(|:[0-9]{2})$/', $correspondObject->start_date ) == 0) {
			$request->addLocaledError('member.error.correspond.invalidstartday',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if ( preg_match( '/^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}\\s[0-9]{2}:[0-9]{2}(|:[0-9]{2})$/', $correspondObject->correspond_date ) == 0) {
			$request->addLocaledError('member.error.correspond.invalidlastday',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$correspondObject);
		$request->setAttribute('member.member.correspond.memberObject',$memberObject);
		$request->setAttribute('member.member.correspond.correspondObject',$correspondObject);
	}
}
?>